/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import org.exolab.jmscts.core.AckType;

public class AckTypes {
    public static final AckType TRANSACTED = AckType.TRANSACTED;
    public static final AckType AUTO_ACKNOWLEDGE = AckType.AUTO_ACKNOWLEDGE;
    public static final AckType CLIENT_ACKNOWLEDGE = AckType.CLIENT_ACKNOWLEDGE;
    public static final AckType DUPS_OK_ACKNOWLEDGE = AckType.DUPS_OK_ACKNOWLEDGE;
    public static final AckTypes ALL = new AckTypes(new AckType[]{TRANSACTED, AUTO_ACKNOWLEDGE, CLIENT_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE});
    public static final AckTypes NON_TRANSACTIONAL = new AckTypes(new AckType[]{AUTO_ACKNOWLEDGE, CLIENT_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE});
    public static final AckTypes TRANSACTIONAL = new AckTypes(TRANSACTED);
    private AckType[] _types;

    public AckTypes(AckType[] types) {
        if (types == null) {
            throw new IllegalArgumentException("Argument types is null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("Argument types has no elements");
        }
        this._types = types;
    }

    public AckTypes(AckType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument type is null");
        }
        this._types = new AckType[]{type};
    }

    public AckType[] getTypes() {
        return this._types;
    }

    public static AckTypes fromString(String[] types) {
        AckTypes result = null;
        AckType[] set = new AckType[types.length];
        for (int i = 0; i < types.length; ++i) {
            if ("all".equalsIgnoreCase(types[i])) {
                result = ALL;
                break;
            }
            set[i] = AckType.fromString(types[i]);
        }
        if (result == null) {
            result = new AckTypes(set);
        }
        return result;
    }
}

