/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.rmi.Naming;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.exolab.jmscts.core.service.RemoteService;
import org.exolab.jmscts.core.service.Snapshot;

public final class Admin {
    private static final String SNAPSHOT = "snapshot";
    private static final String PORT = "port";
    private static final String STOP = "stop";
    private static final String ABORT = "abort";

    private Admin() {
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(SNAPSHOT, true, "snapshot the current test state");
        options.addOption(STOP, false, "stop a running compliance test");
        options.addOption(ABORT, false, "abort a running compliance test");
        options.addOption(PORT, true, "use port to connect to the compliance test");
        GnuParser parser = new GnuParser();
        CommandLine commands = parser.parse(options, args);
        String path = commands.getOptionValue(SNAPSHOT);
        String port = commands.getOptionValue(PORT, "4000");
        if (path != null) {
            String name = Admin.getName(port, "Snapshot");
            Snapshot server = (Snapshot)Naming.lookup(name);
            server.snapshot(path);
        } else if (commands.hasOption(STOP)) {
            String name = Admin.getName(port, "Terminator");
            RemoteService server = (RemoteService)Naming.lookup(name);
            server.stop();
        } else if (commands.hasOption(ABORT)) {
            String name = Admin.getName(port, "Terminator");
            RemoteService server = (RemoteService)Naming.lookup(name);
            server.abort();
        } else {
            Admin.usage();
        }
    }

    private static void usage() {
        System.err.println("usage: " + Admin.class.getName() + " <arguments> [options]\n" + "arguments:\n" + "  -snapshot <path> snapshot the current test state\n" + "  -stop            stop a running compliance test\n" + "  -abort           abort a running compliance test\n" + "options:\n" + "  -port <port>     use port to connect to the compliance test" + "\n");
    }

    private static String getName(String port, String name) {
        return "//localhost:" + port + "/" + name;
    }
}

