/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractMessageReceiver;
import org.exolab.jmscts.core.CachingListener;
import org.exolab.jmscts.core.CountingListener;

class AsynchronousReceiver
extends AbstractMessageReceiver {
    private static final Category log = Category.getInstance((String)AsynchronousReceiver.class.getName());

    public AsynchronousReceiver(Session session, MessageConsumer consumer, String name) {
        super(session, consumer, name);
    }

    public List receive(int count, long timeout) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expecting to receive count=" + count + " messages " + "[destination=" + this.getDestination() + ", timeout=" + timeout + "]"));
        }
        MessageConsumer consumer = this.getConsumer();
        CachingListener listener = new CachingListener(count);
        consumer.setMessageListener((MessageListener)listener);
        try {
            long time;
            long l = time = count == 0 ? timeout : (long)count * timeout;
            if (time > 0L) {
                listener.waitForCompletion(time);
            } else {
                listener.waitForCompletion();
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        consumer.setMessageListener(null);
        return listener.getMessages();
    }

    public void receive(long timeout, CountingListener listener) throws JMSException {
        int count = listener.getExpected();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expecting to receive count=" + count + " messages " + "[destination=" + this.getDestination() + ", timeout=" + timeout + "]"));
        }
        MessageConsumer consumer = this.getConsumer();
        consumer.setMessageListener((MessageListener)listener);
        try {
            long time;
            long l = time = count == 0 ? timeout : (long)count * timeout;
            if (time > 0L) {
                listener.waitForCompletion(time);
            } else {
                listener.waitForCompletion();
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        consumer.setMessageListener(null);
    }
}

