/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.exolab.jmscts.core.Property;
import org.exolab.jmscts.core.PropertyHelper;
import org.exolab.jmscts.core.types.PropertyTypeType;

public final class ClassHelper {
    private static final Class[][] TYPES = new Class[][]{{Boolean.class, Boolean.TYPE}, {Byte.class, Byte.TYPE}, {Short.class, Short.TYPE}, {Character.class, Character.TYPE}, {Integer.class, Integer.TYPE}, {Long.class, Long.TYPE}, {Float.class, Float.TYPE}, {Double.class, Double.TYPE}};
    static /* synthetic */ Class class$java$lang$String;

    private ClassHelper() {
    }

    public static Object instantiate(String className, Property[] properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Object object = Class.forName(className).newInstance();
        for (int i = 0; i < properties.length; ++i) {
            Property property = properties[i];
            Class<?> type = Class.forName(property.getType().toString());
            Class[] types = new Class[]{type};
            String name = "set" + property.getName();
            Method method = object.getClass().getMethod(name, types);
            Object arg = PropertyHelper.create(property);
            Object[] args = new Object[]{arg};
            method.invoke(object, args);
        }
        return object;
    }

    public static Property[] getProperties(Object object) throws IllegalAccessException, InvocationTargetException {
        String prefix = "get";
        ArrayList<Property> result = new ArrayList<Property>();
        Method[] methods = object.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> type;
            Method method = methods[i];
            int modifier = method.getModifiers();
            if (method.getParameterTypes().length != 0 || !Modifier.isPublic(modifier) || Modifier.isStatic(modifier) || !method.getName().startsWith("get") || !(type = method.getReturnType()).equals(class$java$lang$Boolean == null ? ClassHelper.class$("java.lang.Boolean") : class$java$lang$Boolean) && !type.equals(class$java$lang$Short == null ? ClassHelper.class$("java.lang.Short") : class$java$lang$Short) && !type.equals(class$java$lang$Integer == null ? ClassHelper.class$("java.lang.Integer") : class$java$lang$Integer) && !type.equals(class$java$lang$Long == null ? ClassHelper.class$("java.lang.Long") : class$java$lang$Long) && !type.equals(class$java$lang$Float == null ? ClassHelper.class$("java.lang.Float") : class$java$lang$Float) && !type.equals(class$java$lang$Double == null ? ClassHelper.class$("java.lang.Double") : class$java$lang$Double) && !type.equals(class$java$lang$String == null ? ClassHelper.class$("java.lang.String") : class$java$lang$String)) continue;
            Property property = new Property();
            String name = method.getName().substring("get".length());
            property.setName(name);
            property.setType(PropertyTypeType.valueOf(type.getName()));
            Object value = method.invoke(object, new Object[0]);
            property.setValue(value.toString());
            result.add(property);
        }
        return result.toArray(new Property[0]);
    }

    public static Method getMethod(Class type, String name, Object[] args) throws NoSuchMethodException {
        Method method;
        Class[] types;
        block18: {
            boolean containsNull = false;
            types = null;
            if (args != null) {
                types = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] != null) {
                        types[i] = args[i].getClass();
                        continue;
                    }
                    containsNull = true;
                }
            } else {
                types = new Class[]{};
            }
            method = null;
            if (!containsNull) {
                try {
                    method = type.getMethod(name, types);
                }
                catch (NoSuchMethodException ignore) {
                    if (types.length == 0) break block18;
                    Class[] converted = new Class[types.length];
                    for (int i = 0; i < args.length; ++i) {
                        converted[i] = ClassHelper.getPrimitiveType(args[i].getClass());
                    }
                    try {
                        method = type.getMethod(name, types);
                    }
                    catch (NoSuchMethodException ignore2) {
                        // empty catch block
                    }
                }
            }
        }
        if (method == null) {
            int i;
            Method[] methods = type.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getName().equals(name) || !ClassHelper.checkParameters(methods[i], types)) continue;
                method = methods[i];
                break;
            }
            if (method == null) {
                methods = type.getMethods();
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(name) || !ClassHelper.checkParameters(methods[i], types)) continue;
                    method = methods[i];
                    break;
                }
            }
            if (method == null) {
                String msg = "No method found for name=" + name + ", argument types=(";
                if (args != null && args.length > 0) {
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        if (i2 > 0) {
                            msg = msg + ", ";
                        }
                        msg = args[i2] != null ? msg + args[i2].getClass().getName() : msg + "Object";
                    }
                }
                msg = msg + ")";
                throw new NoSuchMethodException(msg);
            }
        }
        return method;
    }

    public static Class getPrimitiveType(Class wrapper) {
        Class result = null;
        for (int i = 0; i < TYPES.length; ++i) {
            if (!wrapper.equals(TYPES[i][0])) continue;
            result = TYPES[i][1];
            break;
        }
        return result != null ? result : wrapper;
    }

    public static String getPrimitiveName(Class wrapper) {
        String result = null;
        Class type = ClassHelper.getPrimitiveType(wrapper);
        result = type.isArray() ? type.getComponentType().getName() + "[]" : type.getName();
        return result;
    }

    private static boolean checkParameters(Method method, Class[] types) {
        boolean result = true;
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length != types.length) {
            result = false;
        } else {
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> parameter = parameters[i];
                if (types[i] == null) {
                    if (!parameter.isPrimitive()) continue;
                    result = false;
                    break;
                }
                if (parameter.isAssignableFrom(types[i]) || parameter.isAssignableFrom(ClassHelper.getPrimitiveType(types[i]))) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

