/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;

public class CompletionListener {
    private int _expected;
    private Semaphore _completedLock;

    public CompletionListener(int expected) {
        this._expected = expected;
        this._completedLock = new Semaphore((long)(-expected + 1));
    }

    public void completed() {
        this._completedLock.release();
    }

    public boolean waitForCompletion(long timeout) throws InterruptedException {
        boolean completed = this._completedLock.attempt(timeout);
        if (completed) {
            this._completedLock.release();
        }
        return completed;
    }

    public void waitForCompletion() throws InterruptedException {
        this._completedLock.acquire();
        this._completedLock.release();
    }

    public int getCompleted() {
        return this._expected + (int)this._completedLock.permits() - 1;
    }
}

