/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestProperties;

public final class ConnectionFactoryHelper {
    private ConnectionFactoryHelper() {
    }

    public static Connection createConnection(TestContext context, String clientID) throws JMSException {
        String user = TestProperties.getString("valid.username", null);
        String password = TestProperties.getString("valid.password", null);
        QueueConnection result = null;
        if (context.isQueueConnectionFactory()) {
            QueueConnectionFactory factory = (QueueConnectionFactory)context.getConnectionFactory();
            result = factory.createQueueConnection(user, password);
        } else if (context.isTopicConnectionFactory()) {
            TopicConnectionFactory factory = (TopicConnectionFactory)context.getConnectionFactory();
            result = factory.createTopicConnection(user, password);
        } else if (context.isXAQueueConnectionFactory()) {
            XAQueueConnectionFactory factory = (XAQueueConnectionFactory)context.getConnectionFactory();
            result = factory.createXAQueueConnection(user, password);
        } else if (context.isXATopicConnectionFactory()) {
            XATopicConnectionFactory factory = (XATopicConnectionFactory)context.getConnectionFactory();
            result = factory.createXATopicConnection(user, password);
        } else {
            throw new JMSException("Unknown connection factory type");
        }
        if (clientID != null) {
            result.setClientID(clientID);
        }
        return result;
    }
}

