/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;

public final class ConnectionFactoryTypes {
    public static final ConnectionFactoryTypes QUEUE;
    public static final ConnectionFactoryTypes TOPIC;
    public static final ConnectionFactoryTypes XAQUEUE;
    public static final ConnectionFactoryTypes XATOPIC;
    public static final ConnectionFactoryTypes ALL_QUEUE;
    public static final ConnectionFactoryTypes ALL_TOPIC;
    public static final ConnectionFactoryTypes ALL;
    public static final Class[] TYPES;
    private final Class[] _types;

    private ConnectionFactoryTypes(Class type) {
        this(new Class[]{type});
    }

    private ConnectionFactoryTypes(Class[] types) {
        this._types = types;
    }

    public Class[] getTypes() {
        return this._types;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this._types.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this._types[i].getName());
        }
        return result.toString();
    }

    public int count() {
        return this._types.length;
    }

    public static Class getType(ConnectionFactory factory) {
        Class result = null;
        for (int i = 0; i < TYPES.length; ++i) {
            if (!TYPES[i].isAssignableFrom(factory.getClass())) continue;
            result = TYPES[i];
            break;
        }
        return result;
    }

    public static ConnectionFactoryTypes fromString(String name) {
        ConnectionFactoryTypes result = null;
        if ("all".equalsIgnoreCase(name)) {
            result = ALL;
        } else {
            name = "javax.jms." + name;
            Class[] types = ALL.getTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].getName().equals(name)) continue;
                result = new ConnectionFactoryTypes(types[i]);
                break;
            }
        }
        return result;
    }

    public static ConnectionFactoryTypes fromString(String[] names) {
        ConnectionFactoryTypes result = null;
        Class[] classes = new Class[names.length];
        for (int i = 0; i < names.length; ++i) {
            if ("all".equalsIgnoreCase(names[i])) {
                result = ALL;
                break;
            }
            Class[] types = ALL.getTypes();
            String name = "javax.jms." + names[i];
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].getName().equals(name)) continue;
                classes[i] = types[j];
                break;
            }
            if (classes[i] != null) continue;
            throw new IllegalArgumentException("Invalid factory: " + names[i]);
        }
        if (result == null) {
            result = new ConnectionFactoryTypes(classes);
        }
        return result;
    }

    static {
        TYPES = new Class[]{QueueConnectionFactory.class, TopicConnectionFactory.class, XAQueueConnectionFactory.class, XATopicConnectionFactory.class};
        QUEUE = new ConnectionFactoryTypes(new Class[]{QueueConnectionFactory.class});
        TOPIC = new ConnectionFactoryTypes(new Class[]{TopicConnectionFactory.class});
        XAQUEUE = new ConnectionFactoryTypes(new Class[]{XAQueueConnectionFactory.class});
        XATOPIC = new ConnectionFactoryTypes(new Class[]{XATopicConnectionFactory.class});
        ALL_QUEUE = new ConnectionFactoryTypes(new Class[]{QueueConnectionFactory.class, XAQueueConnectionFactory.class});
        ALL_TOPIC = new ConnectionFactoryTypes(new Class[]{TopicConnectionFactory.class, XATopicConnectionFactory.class});
        ALL = new ConnectionFactoryTypes(new Class[]{QueueConnectionFactory.class, TopicConnectionFactory.class, XAQueueConnectionFactory.class, XATopicConnectionFactory.class});
    }
}

