/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.TestContext;

public final class ConnectionHelper {
    private ConnectionHelper() {
    }

    public static Session createSession(TestContext context, AckType type) throws JMSException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' is null");
        }
        if (context.getConnection() == null) {
            throw new IllegalArgumentException("Argument 'context' is not a connection context");
        }
        QueueSession result = null;
        if (context.isQueueConnectionFactory()) {
            QueueConnection connection = (QueueConnection)context.getConnection();
            result = connection.createQueueSession(type.getTransacted(), type.getAcknowledgeMode());
        } else if (context.isTopicConnectionFactory()) {
            TopicConnection connection = (TopicConnection)context.getConnection();
            result = connection.createTopicSession(type.getTransacted(), type.getAcknowledgeMode());
        } else if (context.isXAQueueConnectionFactory()) {
            XAQueueConnection connection = (XAQueueConnection)context.getConnection();
            result = connection.createXAQueueSession();
        } else {
            XATopicConnection connection = (XATopicConnection)context.getConnection();
            result = connection.createXATopicSession();
        }
        return result;
    }

    public static Session createSession(TestContext context) throws JMSException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (context.getSession() == null) {
            throw new IllegalArgumentException("Argument 'context' is not a session context");
        }
        return ConnectionHelper.createSession(context, context.getAckType());
    }

    public static ConnectionConsumer createConnectionConsumer(TestContext context, Destination destination, String name, String selector, ServerSessionPool pool, int maxMessages) throws JMSException {
        ConnectionConsumer result;
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Argument 'pool' is null");
        }
        if (context.getConnection() == null) {
            throw new IllegalArgumentException("Argument 'context' is not a connection context");
        }
        if (context.isQueue()) {
            QueueConnection connection = (QueueConnection)context.getConnection();
            result = connection.createConnectionConsumer((Queue)destination, selector, pool, maxMessages);
        } else {
            TopicConnection connection = (TopicConnection)context.getConnection();
            result = name == null ? connection.createConnectionConsumer((Topic)destination, selector, pool, maxMessages) : connection.createDurableConnectionConsumer((Topic)destination, name, selector, pool, maxMessages);
        }
        return result;
    }
}

