/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import javax.jms.Message;
import javax.jms.MessageListener;

public class CountingListener
implements MessageListener {
    private final int _expected;
    private volatile int _count = 0;
    private Semaphore _completedLock = new Semaphore(0L);

    public CountingListener(int expected) {
        this._expected = expected;
    }

    public void onMessage(Message message) {
        if (++this._count >= this._expected) {
            this._completedLock.release();
        }
    }

    public int getExpected() {
        return this._expected;
    }

    public int getReceived() {
        return this._count;
    }

    public boolean waitForCompletion(long timeout) throws InterruptedException {
        boolean completed = this._completedLock.attempt(timeout);
        if (completed) {
            this._completedLock.release();
        }
        return completed;
    }

    public void waitForCompletion() throws InterruptedException {
        this._completedLock.acquire();
        this._completedLock.release();
    }
}

