/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.StringTokenizer;
import org.exolab.jmscts.core.ReceiptType;

public class DeliveryType {
    private final int _deliveryMode;
    private final boolean _administered;
    private final ReceiptType _receipt;

    public DeliveryType(boolean persistent, boolean administered) {
        this(persistent, administered, null);
    }

    public DeliveryType(boolean persistent, boolean administered, ReceiptType receipt) {
        this._deliveryMode = persistent ? 2 : 1;
        this._administered = administered;
        this._receipt = receipt;
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public boolean getAdministered() {
        return this._administered;
    }

    public ReceiptType getReceiptType() {
        return this._receipt;
    }

    public static DeliveryType fromString(String type) {
        DeliveryType result;
        int minTokens = 2;
        int maxTokens = 3;
        boolean persistent = false;
        boolean administered = false;
        ReceiptType receipt = null;
        StringTokenizer tokens = new StringTokenizer(type, ", ");
        int count = tokens.countTokens();
        if (count < 2 || count > 3) {
            throw new IllegalArgumentException("Invalid delivery type: " + type);
        }
        String persistentStr = tokens.nextToken();
        String administeredStr = tokens.nextToken();
        if ("PERSISTENT".equals(persistentStr)) {
            persistent = true;
        } else if (!"NON_PERSISTENT".equals(persistentStr)) {
            throw new IllegalArgumentException("Invalid delivery mode: expected one of PERSISTENT or NON_PERSISTENT but got " + persistentStr);
        }
        if ("administered".equals(administeredStr)) {
            administered = true;
        } else if (!"temporary".equals(administeredStr)) {
            throw new IllegalArgumentException("Invalid destination type: expected one of administered or temporary but got " + administeredStr);
        }
        String receiptStr = null;
        if (count == 3) {
            receiptStr = tokens.nextToken();
            receipt = ReceiptType.fromString(receiptStr);
            result = new DeliveryType(persistent, administered, receipt);
        } else {
            result = new DeliveryType(persistent, administered);
        }
        return result;
    }
}

