/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import javax.naming.NamingException;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.provider.Administrator;

public final class DestinationHelper {
    private DestinationHelper() {
    }

    public static Destination create(TestContext context, String name) throws JMSException, NamingException {
        Destination result = null;
        boolean isQueue = context.isQueueConnectionFactory() || context.isXAQueueConnectionFactory();
        MessagingBehaviour behaviour = context.getMessagingBehaviour();
        result = behaviour == null || behaviour.getAdministered() ? DestinationHelper.create(name, isQueue, context.getAdministrator()) : DestinationHelper.create(context.getSession());
        return result;
    }

    public static Destination create(String name, boolean queue, Administrator admin) throws JMSException, NamingException {
        admin.createDestination(name, queue);
        return (Destination)admin.lookup(name);
    }

    public static Destination create(Session session) throws JMSException {
        Object result = null;
        if (session instanceof XAQueueSession) {
            session = ((XAQueueSession)session).getQueueSession();
        } else if (session instanceof XATopicSession) {
            session = ((XATopicSession)session).getTopicSession();
        }
        result = session instanceof QueueSession ? ((QueueSession)session).createTemporaryQueue() : ((TopicSession)session).createTemporaryTopic();
        return result;
    }

    public static void destroy(TestContext context, Destination destination) throws JMSException {
        DestinationHelper.destroy(destination, context.getAdministrator());
    }

    public static void destroy(String name, Administrator admin) throws JMSException {
        if (admin.destinationExists(name)) {
            admin.destroyDestination(name);
        }
    }

    public static void destroy(Destination destination, Administrator admin) throws JMSException {
        if (destination instanceof TemporaryQueue) {
            ((TemporaryQueue)destination).delete();
        } else if (destination instanceof TemporaryTopic) {
            ((TemporaryTopic)destination).delete();
        } else {
            DestinationHelper.destroy(DestinationHelper.getName(destination), admin);
        }
    }

    public static boolean equal(Destination a, Destination b) throws JMSException {
        boolean equal = false;
        if (a instanceof Queue && b instanceof Queue) {
            String nameA = ((Queue)a).getQueueName();
            String nameB = ((Queue)b).getQueueName();
            equal = nameA.equals(nameB);
        } else if (a instanceof Topic && b instanceof Topic) {
            String nameA = ((Topic)a).getTopicName();
            String nameB = ((Topic)b).getTopicName();
            equal = nameA.equals(nameB);
        }
        return equal;
    }

    public static String getName(Destination destination) throws JMSException {
        String name = null;
        name = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
        return name;
    }
}

