/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.MessageSender;

public class EchoListener
implements MessageListener {
    private Session _session;
    private MessageSender _sender;
    private int _count = 0;
    private boolean _commit = false;
    private static final Category log = Category.getInstance((String)EchoListener.class.getName());

    public EchoListener(MessageSender sender, int count) {
        this(null, sender, count, false);
    }

    public EchoListener(Session session, MessageSender sender, int count, boolean commit) {
        this._session = session;
        this._sender = sender;
        this._count = count;
        this._commit = commit;
    }

    public void onMessage(Message message) {
        try {
            this._sender.send(message, this._count);
            if (this._commit && this._session != null && this._session.getTransacted()) {
                this._session.commit();
            }
        }
        catch (Exception exception) {
            log.error((Object)exception, (Throwable)exception);
        }
    }
}

