/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;
import org.apache.log4j.Category;

public class JUnitTestRunner
extends BaseTestRunner {
    private static final Category SUMMARY_LOG = Category.getInstance((String)(JUnitTestRunner.class.getName() + ".Summary"));
    private static final Category TRACE_LOG = Category.getInstance((String)(JUnitTestRunner.class.getName() + ".Trace"));
    private static final Category DETAIL_LOG = Category.getInstance((String)(JUnitTestRunner.class.getName() + ".Detail"));

    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    public void testStarted(String testName) {
    }

    public void testEnded(String testName) {
    }

    public void testFailed(int status, Test test, Throwable error) {
    }

    public TestResult doRun(Test suite) {
        TestResult result = this.createTestResult();
        result.addListener((TestListener)this);
        long startTime = System.currentTimeMillis();
        suite.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        SUMMARY_LOG.info((Object)("Time: " + this.elapsedTimeAsString(runTime)));
        this.log(result);
        return result;
    }

    public void startTest(Test test) {
        TRACE_LOG.info((Object)("Running: " + test));
    }

    public void addError(Test test, Throwable error) {
        TRACE_LOG.info((Object)("Error: " + test));
    }

    public void addFailure(Test test, AssertionFailedError error) {
        TRACE_LOG.info((Object)("Failed: " + test));
    }

    public synchronized void log(TestResult result) {
        this.logErrors(result);
        this.logFailures(result);
        this.logHeader(result);
    }

    public void logErrors(TestResult result) {
        if (result.errorCount() != 0) {
            if (result.errorCount() == 1) {
                DETAIL_LOG.error((Object)("There was " + result.errorCount() + " error:"));
            } else {
                DETAIL_LOG.error((Object)("There were " + result.errorCount() + " errors:"));
            }
            int i = 1;
            Enumeration e = result.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                DETAIL_LOG.error((Object)(i + ") " + failure.failedTest()), failure.thrownException());
                ++i;
            }
        }
    }

    public void logFailures(TestResult result) {
        if (result.failureCount() != 0) {
            if (result.failureCount() == 1) {
                DETAIL_LOG.error((Object)("There was " + result.failureCount() + " failure:"));
            } else {
                DETAIL_LOG.error((Object)("There were " + result.failureCount() + " failures:"));
                int i = 1;
                Enumeration e = result.failures();
                while (e.hasMoreElements()) {
                    TestFailure failure = (TestFailure)e.nextElement();
                    DETAIL_LOG.error((Object)(i + ") " + failure.failedTest()), failure.thrownException());
                    ++i;
                }
            }
        }
    }

    public void logHeader(TestResult result) {
        if (result.wasSuccessful()) {
            SUMMARY_LOG.info((Object)("OK (" + result.runCount() + " tests)"));
        } else {
            SUMMARY_LOG.info((Object)"FAILURES!!!");
            SUMMARY_LOG.info((Object)("Tests run: " + result.runCount() + ",  Failures: " + result.failureCount() + ",  Errors: " + result.errorCount()));
        }
    }

    public static void run(Class testClass) {
        JUnitTestRunner.run((Test)new TestSuite(testClass));
    }

    public static void run(Test suite) {
        JUnitTestRunner runner = new JUnitTestRunner();
        runner.doRun(suite);
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected void runFailed(String message) {
        DETAIL_LOG.error((Object)message);
        System.exit(-1);
    }
}

