/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.io.Serializable;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.AbstractMessagePopulator;

public class MessageSizePopulator
extends AbstractMessagePopulator {
    private final String _content;

    public MessageSizePopulator(int size) {
        char[] buffer = new char[size / 2 + size % 2];
        Arrays.fill(buffer, 'A');
        this._content = new String(buffer);
    }

    public void populateBytesMessage(BytesMessage message) throws Exception {
        message.writeUTF(this._content);
    }

    public void populateMapMessage(MapMessage message) throws Exception {
        message.setString("content", this._content);
    }

    public void populateObjectMessage(ObjectMessage message) throws Exception {
        message.setObject((Serializable)((Object)this._content));
    }

    public void populateStreamMessage(StreamMessage message) throws Exception {
        message.writeString(this._content);
    }

    public void populateTextMessage(TextMessage message) throws Exception {
        message.setText(this._content);
    }
}

