/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import junit.framework.TestResult;
import org.exolab.jmscts.core.JMSTest;
import org.exolab.jmscts.core.MessageCreator;
import org.exolab.jmscts.core.MessageTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;
import org.exolab.jmscts.core.TestInvoker;

abstract class MessageTestInvoker
extends TestInvoker {
    private final Class _type;

    public MessageTestInvoker(Test test, TestResult result, TestContext context, TestFilter filter, Class type) {
        super(test, result, context, filter);
        if (!(test instanceof MessageTestCase)) {
            throw new IllegalArgumentException("Argument 'test' must implement MessageTestCase");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' is null");
        }
        this._type = type;
    }

    protected void setUp(JMSTest test, TestContext context) throws Exception {
        MessageTestCase messageTest = (MessageTestCase)test;
        if (!messageTest.share()) {
            if (messageTest.startConnection()) {
                context.getConnection().start();
            }
        } else {
            Connection connection = context.getConnection();
            if (messageTest.startConnection()) {
                connection.start();
            } else {
                connection.stop();
            }
        }
    }

    protected Message create() throws Exception {
        MessageTestCase test = (MessageTestCase)this.getTest();
        TestContext context = this.getContext();
        Session session = context.getSession();
        MessageCreator creator = new MessageCreator(session, test.getMessagePopulator());
        return creator.create(this._type);
    }

    protected Class getMessageType() {
        return this._type;
    }
}

