/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.Iterator;
import java.util.Map;
import javax.jms.Message;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.Property;
import org.exolab.jmscts.core.PropertyHelper;

public class PropertyPopulator
implements MessagePopulator {
    private Property[] _list = null;
    private Map _map = null;

    public PropertyPopulator(Property[] properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 'properties' is null");
        }
        this._list = properties;
    }

    public PropertyPopulator(Map properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 'properties' is null");
        }
        this._map = properties;
    }

    public void populate(Message message) throws Exception {
        if (this._list != null) {
            for (int i = 0; i < this._list.length; ++i) {
                Property property = this._list[i];
                Object value = PropertyHelper.create(property);
                message.setObjectProperty(property.getName(), value);
            }
        } else {
            Iterator iterator = this._map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                message.setObjectProperty(name, value);
            }
        }
    }
}

