/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractMessageSender;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageTypes;
import org.exolab.jmscts.core.MessagingBehaviour;

class QueueMessageSender
extends AbstractMessageSender {
    private static final Category log = Category.getInstance((Class)QueueMessageSender.class);

    public QueueMessageSender(QueueSender sender) {
        super((MessageProducer)sender, new MessagingBehaviour());
    }

    public QueueMessageSender(QueueSender sender, MessagingBehaviour behaviour) {
        super((MessageProducer)sender, behaviour);
    }

    public void send(Message message, int count, MessagePopulator populator, long timeToLive) throws JMSException {
        MessagingBehaviour behaviour = this.getBehaviour();
        int deliveryMode = behaviour.getDeliveryMode();
        int priority = behaviour.getPriority();
        QueueSender sender = (QueueSender)this.getProducer();
        for (int i = 0; i < count; ++i) {
            if (populator != null) {
                try {
                    populator.populate(message);
                }
                catch (Exception exception) {
                    JMSException error = new JMSException(exception.getMessage());
                    error.setLinkedException(exception);
                    throw error;
                }
            }
            if (log.isDebugEnabled()) {
                Class type = MessageTypes.getType(message);
                log.debug((Object)("Sending message [message=" + type.getName() + ", queue=" + this.getDestination() + ", deliveryMode=" + deliveryMode + ", priority=" + priority + ", timeToLive=" + timeToLive + "]"));
            }
            sender.send(message, deliveryMode, priority, timeToLive);
        }
    }
}

