/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.exolab.jmscts.core.AbstractMessageTestRunner;
import org.exolab.jmscts.core.DeliveryType;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.SendReceiveTestCase;
import org.exolab.jmscts.core.SendReceiveTestInvoker;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;

public class SendReceiveTestRunner
extends AbstractMessageTestRunner {
    public SendReceiveTestRunner(SendReceiveTestCase test) {
        super(test);
    }

    public int countTestCases() {
        int count = super.countTestCases();
        SendReceiveTestCase test = (SendReceiveTestCase)this.getTest();
        DeliveryType[] types = test.getDeliveryTypes().getTypes();
        int deliveryTypes = 0;
        int durable = 0;
        if (this.getContext().isQueueConnectionFactory()) {
            deliveryTypes = types.length;
        } else {
            for (int i = 0; i < types.length; ++i) {
                DeliveryType type = types[i];
                ReceiptType receipt = type.getReceiptType();
                if (ReceiptType.BROWSER.equals(receipt)) continue;
                if (types[i].getAdministered() && !test.getDurableOnly()) {
                    ++deliveryTypes;
                }
                if (!types[i].getAdministered()) continue;
                ++durable;
            }
        }
        return (deliveryTypes + durable) * count;
    }

    protected void runTest(Test test, TestResult result, Class messageType) {
        TestContext context = this.getContext();
        SendReceiveTestCase sendReceive = (SendReceiveTestCase)test;
        DeliveryType[] types = sendReceive.getDeliveryTypes().getTypes();
        boolean isTopic = context.isTopic();
        TestFilter filter = this.getFilter();
        for (int i = 0; i < types.length && !result.shouldStop(); ++i) {
            DeliveryType type = types[i];
            ReceiptType receipt = type.getReceiptType();
            if (isTopic && ReceiptType.BROWSER.equals(receipt)) continue;
            MessagingBehaviour behaviour = new MessagingBehaviour(type);
            if (!this.filtered(behaviour, messageType, test)) {
                this.runTest(test, result, messageType, behaviour);
            }
            if (receipt == null || !isTopic || !type.getAdministered()) continue;
            behaviour.setDurable(true);
            if (this.filtered(behaviour, messageType, test)) continue;
            this.runTest(test, result, messageType, behaviour);
        }
    }

    protected void runTest(Test test, TestResult result, Class messageType, MessagingBehaviour behaviour) {
        SendReceiveTestInvoker tester = new SendReceiveTestInvoker(test, result, this.getContext(), this.getFilter(), messageType, behaviour);
        result.runProtected(test, (Protectable)tester);
    }

    private boolean filtered(MessagingBehaviour behaviour, Class messageType, Test test) {
        TestFilter filter;
        boolean result = false;
        SendReceiveTestCase sendReceive = (SendReceiveTestCase)test;
        TestContext context = this.getContext();
        result = context.isTopic() && behaviour.getAdministered() && sendReceive.getDurableOnly() && !behaviour.getDurable() ? true : (filter = this.getFilter()) != null && !filter.includes(context, behaviour, messageType, test);
        return result;
    }
}

