/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import org.exolab.jmscts.core.AbstractMessageSender;
import org.exolab.jmscts.core.AsynchronousReceiver;
import org.exolab.jmscts.core.MessageBrowser;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.QueueMessageSender;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.SynchronousReceiver;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TopicMessageSender;

public final class SessionHelper {
    private static int _subscriberSeed = 0;

    private SessionHelper() {
    }

    public static MessageConsumer createConsumer(Session session, Destination destination, String name) throws JMSException {
        QueueReceiver result = null;
        if (session instanceof XAQueueSession) {
            session = ((XAQueueSession)session).getQueueSession();
        } else if (session instanceof XATopicSession) {
            session = ((XATopicSession)session).getTopicSession();
        }
        if (session instanceof QueueSession) {
            Queue queue = (Queue)destination;
            result = ((QueueSession)session).createReceiver(queue);
        } else {
            Topic topic = (Topic)destination;
            result = name != null ? ((TopicSession)session).createDurableSubscriber(topic, name) : ((TopicSession)session).createSubscriber(topic);
        }
        return result;
    }

    public static MessageConsumer createConsumer(Session session, Destination destination, String name, String selector, boolean noLocal) throws JMSException {
        QueueReceiver result = null;
        if (session instanceof XAQueueSession) {
            session = ((XAQueueSession)session).getQueueSession();
        } else if (session instanceof XATopicSession) {
            session = ((XATopicSession)session).getTopicSession();
        }
        if (session instanceof QueueSession) {
            Queue queue = (Queue)destination;
            result = ((QueueSession)session).createReceiver(queue, selector);
        } else {
            Topic topic = (Topic)destination;
            result = name != null ? ((TopicSession)session).createDurableSubscriber(topic, name, selector, noLocal) : ((TopicSession)session).createSubscriber(topic, selector, noLocal);
        }
        return result;
    }

    public static MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        QueueSender result = null;
        if (session instanceof XAQueueSession) {
            session = ((XAQueueSession)session).getQueueSession();
        } else if (session instanceof XATopicSession) {
            session = ((XATopicSession)session).getTopicSession();
        }
        if (session instanceof QueueSession) {
            Queue queue = (Queue)destination;
            result = ((QueueSession)session).createSender(queue);
        } else {
            Topic topic = (Topic)destination;
            result = ((TopicSession)session).createPublisher(topic);
        }
        return result;
    }

    public static MessageConsumer createConsumer(TestContext context, Destination destination, String name) throws JMSException {
        return SessionHelper.createConsumer(context.getSession(), destination, name);
    }

    public static MessageProducer createProducer(TestContext context, Destination destination) throws JMSException {
        return SessionHelper.createProducer(context.getSession(), destination);
    }

    public static MessageReceiver createReceiver(Session session, Destination destination, MessagingBehaviour behaviour) throws JMSException {
        MessageReceiver result = null;
        if (behaviour.getReceiptType().equals(ReceiptType.BROWSER)) {
            result = new MessageBrowser((QueueSession)session, (Queue)destination);
        } else {
            String name = null;
            if (behaviour.getDurable()) {
                name = SessionHelper.getSubscriberName();
            }
            MessageConsumer consumer = SessionHelper.createConsumer(session, destination, name);
            result = behaviour.getReceiptType().equals(ReceiptType.SYNCHRONOUS) ? new SynchronousReceiver(session, consumer, name) : new AsynchronousReceiver(session, consumer, name);
        }
        return result;
    }

    public static MessageReceiver createReceiver(Session session, Destination destination, MessagingBehaviour behaviour, String selector, boolean noLocal) throws JMSException {
        return SessionHelper.createReceiver(session, destination, behaviour, null, selector, noLocal);
    }

    public static MessageReceiver createReceiver(Session session, Destination destination, MessagingBehaviour behaviour, String name, String selector, boolean noLocal) throws JMSException {
        MessageReceiver result = null;
        if (behaviour.getReceiptType().equals(ReceiptType.BROWSER)) {
            result = new MessageBrowser((QueueSession)session, (Queue)destination, selector);
        } else {
            if (behaviour.getDurable() && name == null) {
                name = SessionHelper.getSubscriberName();
            }
            MessageConsumer consumer = SessionHelper.createConsumer(session, destination, name, selector, noLocal);
            result = behaviour.getReceiptType().equals(ReceiptType.SYNCHRONOUS) ? new SynchronousReceiver(session, consumer, name) : new AsynchronousReceiver(session, consumer, name);
        }
        return result;
    }

    public static MessageReceiver createReceiver(TestContext context, Destination destination) throws JMSException {
        return SessionHelper.createReceiver(context.getSession(), destination, context.getMessagingBehaviour());
    }

    public static MessageReceiver createReceiver(TestContext context, Destination destination, String selector, boolean noLocal) throws JMSException {
        return SessionHelper.createReceiver(context.getSession(), destination, context.getMessagingBehaviour(), selector, noLocal);
    }

    public static MessageReceiver createReceiver(TestContext context, Destination destination, String name, String selector, boolean noLocal) throws JMSException {
        return SessionHelper.createReceiver(context.getSession(), destination, context.getMessagingBehaviour(), name, selector, noLocal);
    }

    public static MessageSender createSender(Session session, Destination destination, MessagingBehaviour behaviour) throws JMSException {
        AbstractMessageSender result = null;
        MessageProducer producer = SessionHelper.createProducer(session, destination);
        if (session instanceof XAQueueSession) {
            session = ((XAQueueSession)session).getQueueSession();
        } else if (session instanceof XATopicSession) {
            session = ((XATopicSession)session).getTopicSession();
        }
        result = session instanceof QueueSession ? new QueueMessageSender((QueueSender)producer, behaviour) : new TopicMessageSender((TopicPublisher)producer, behaviour);
        return result;
    }

    public static MessageSender createSender(TestContext context, Destination destination) throws JMSException {
        return SessionHelper.createSender(context.getSession(), destination, context.getMessagingBehaviour());
    }

    public static synchronized String getSubscriberName() {
        return "subscriber" + ++_subscriberSeed;
    }
}

