/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractMessageReceiver;
import org.exolab.jmscts.core.CountingListener;

class SynchronousReceiver
extends AbstractMessageReceiver {
    private static final Category log = Category.getInstance((Class)SynchronousReceiver.class);

    public SynchronousReceiver(Session session, MessageConsumer consumer, String name) {
        super(session, consumer, name);
    }

    public List receive(int count, long timeout) throws JMSException {
        ArrayList<Message> result = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expecting to receive count=" + count + " messages " + "[destination=" + this.getDestination() + ", timeout=" + timeout + "]"));
        }
        if (count == 0) {
            Message message = this.getConsumer().receive(timeout);
            if (message != null) {
                result = new ArrayList<Message>();
                result.add(message);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                Message message = this.getConsumer().receive(timeout);
                if (message == null) continue;
                if (result == null) {
                    result = new ArrayList(count);
                }
                result.add(message);
            }
        }
        return result;
    }

    public void receive(long timeout, CountingListener listener) throws JMSException {
        int count = listener.getExpected();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expecting to receive count=" + count + " messages " + "[destination=" + this.getDestination() + ", timeout=" + timeout + "]"));
        }
        if (count == 0) {
            Message message = this.getConsumer().receive(timeout);
            if (message != null) {
                listener.onMessage(message);
            }
        } else {
            while (listener.getReceived() < count) {
                Message message = this.getConsumer().receive(timeout);
                if (message == null) continue;
                listener.onMessage(message);
            }
        }
    }
}

