/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.JMSException;
import javax.naming.NamingException;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.exolab.jmscts.core.JMSTestCase;
import org.exolab.jmscts.core.TestCoverage;

class TestCoverageListener
implements TestListener {
    private final TestCoverage _coverage;

    public TestCoverageListener(TestCoverage coverage) {
        if (coverage == null) {
            throw new IllegalArgumentException("Argument 'coverage' is null");
        }
        this._coverage = coverage;
    }

    public void addError(Test test, Throwable error) {
        Throwable cause = null;
        if (error instanceof JMSException) {
            cause = ((JMSException)error).getLinkedException();
        } else if (error instanceof NamingException) {
            cause = ((NamingException)error).getRootCause();
        }
        this._coverage.failed(test, error, cause);
    }

    public void addFailure(Test test, AssertionFailedError error) {
        if (test instanceof JMSTestCase) {
            this._coverage.failed(test, (Throwable)error, null);
        }
    }

    public void endTest(Test test) {
        if (test instanceof JMSTestCase) {
            this._coverage.end((JMSTestCase)test);
        }
    }

    public void startTest(Test test) {
        if (test instanceof JMSTestCase) {
            this._coverage.begin((JMSTestCase)test);
        }
    }
}

