/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueConnectionFactory;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Category;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.AckTypes;
import org.exolab.jmscts.core.ConnectionFactoryTypes;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.filter.Exclude;
import org.exolab.jmscts.core.filter.Filter;
import org.exolab.jmscts.core.filter.Include;
import org.exolab.jmscts.core.filter.Selector;
import org.exolab.jmscts.core.types.DeliveryModeType;
import org.exolab.jmscts.core.types.DestinationType;
import org.exolab.jmscts.core.types.FactoryType;
import org.exolab.jmscts.core.types.MessageType;
import org.exolab.jmscts.core.types.ReceiverType;
import org.exolab.jmscts.core.types.SessionType;

public class TestFilter {
    private Filter _filter;
    private Include[] _includes;
    private Exclude[] _excludes;
    private PatternMatcher _matcher = new Perl5Matcher();
    private static final Category log = Category.getInstance((Class)TestFilter.class);
    private static final HashMap FACTORIES = new HashMap();
    private static final HashMap SESSIONS;
    private static final HashMap MESSAGES;

    public TestFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 'filter' is null");
        }
        this._filter = filter;
        this._includes = this._filter.getInclude();
        this._excludes = this._filter.getExclude();
    }

    public boolean includes(Class factoryType, Test test) {
        boolean result = false;
        FactoryType factory = (FactoryType)FACTORIES.get(factoryType);
        if (!this.excludes(factory, null, null, null, null, null, test) && this.includes(factory, null, null, null, null, null, test)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("include(factory=" + factory + ", test=" + this.getTestName(test) + ")=" + result));
        }
        return result;
    }

    public boolean includes(TestContext context, AckType mode, Test test) {
        SessionType session;
        boolean result = false;
        FactoryType factory = (FactoryType)FACTORIES.get(ConnectionFactoryTypes.getType(context.getConnectionFactory()));
        if (!this.excludes(factory, session = (SessionType)SESSIONS.get(mode), null, null, null, null, test) && this.includes(factory, session, null, null, null, null, test)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("include(factory=" + factory + ", session=" + session + ", test=" + this.getTestName(test) + ")=" + result));
        }
        return result;
    }

    public boolean includes(TestContext context, Class messageType, Test test) {
        MessageType message;
        SessionType session;
        boolean result = false;
        FactoryType factory = (FactoryType)FACTORIES.get(ConnectionFactoryTypes.getType(context.getConnectionFactory()));
        if (!this.excludes(factory, session = (SessionType)SESSIONS.get(context.getAckType()), null, null, null, message = (MessageType)MESSAGES.get(messageType), test) && this.includes(factory, session, null, null, null, message, test)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("include(factory=" + factory + ", session=" + session + ", message=" + message + ", test=" + this.getTestName(test) + ")=" + result));
        }
        return result;
    }

    public boolean includes(TestContext context, MessagingBehaviour behaviour, Class messageType, Test test) {
        MessageType message;
        boolean result = false;
        FactoryType factory = (FactoryType)FACTORIES.get(ConnectionFactoryTypes.getType(context.getConnectionFactory()));
        SessionType session = (SessionType)SESSIONS.get(context.getAckType());
        DestinationType destination = behaviour.getAdministered() ? DestinationType.ADMINISTERED : DestinationType.TEMPORARY;
        DeliveryModeType delivery = behaviour.getDeliveryMode() == 2 ? DeliveryModeType.PERSISTENT : DeliveryModeType.NON_PERSISTENT;
        ReceiverType receiver = null;
        ReceiptType receipt = behaviour.getReceiptType();
        if (receipt != null) {
            receiver = receipt.equals(ReceiptType.SYNCHRONOUS) ? (behaviour.getDurable() ? ReceiverType.DURABLE_SYNCHRONOUS : ReceiverType.SYNCHRONOUS) : (receipt.equals(ReceiptType.ASYNCHRONOUS) ? (behaviour.getDurable() ? ReceiverType.DURABLE_ASYNCHRONOUS : ReceiverType.ASYNCHRONOUS) : ReceiverType.BROWSER);
        }
        if (!this.excludes(factory, session, destination, delivery, receiver, message = (MessageType)MESSAGES.get(messageType), test) && this.includes(factory, session, destination, delivery, receiver, message, test)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("include(factory=" + factory + ", session=" + session + ", destination=" + destination + ", delivery=" + delivery + ", receiver=" + receiver + ", message=" + message + ", test=" + test + ")=" + result));
        }
        return result;
    }

    private boolean includes(FactoryType factory, SessionType session, DestinationType destination, DeliveryModeType delivery, ReceiverType receiver, MessageType message, Test test) {
        boolean result;
        boolean bl = result = this._includes == null || this._includes.length == 0;
        if (!result) {
            for (int i = 0; i < this._includes.length; ++i) {
                if (!this.includes(this._includes[i], factory, session, destination, delivery, receiver, message, test)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean includes(Selector selector, FactoryType factory, SessionType session, DestinationType destination, DeliveryModeType delivery, ReceiverType receiver, MessageType message, Test test) {
        boolean result = false;
        result = selector.getTest() == null ? true : (test != null ? this.containsTest(test, selector.getTest()) : true);
        if (result) {
            result = this.includes(selector.getFactory(), factory) && this.includes(selector.getSession(), session) && this.includes(selector.getDestination(), destination) && this.includes(selector.getDeliveryMode(), delivery) && this.includes(selector.getReceiver(), receiver) && this.includes(selector.getMessage(), message);
        }
        return result;
    }

    private boolean includes(Object selector, Object object) {
        boolean result = false;
        if (selector == null || selector.equals(object) || object == null) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("includes(selector=" + selector + ", object=" + object + ")=" + result));
        }
        return result;
    }

    private boolean excludes(FactoryType factory, SessionType session, DestinationType destination, DeliveryModeType delivery, ReceiverType receiver, MessageType message, Test test) {
        boolean result = false;
        if (this._excludes != null && this._excludes.length != 0) {
            for (int i = 0; i < this._excludes.length; ++i) {
                if (!this.excludes(this._excludes[i], factory, session, destination, delivery, receiver, message, test)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean excludes(Selector selector, FactoryType factory, SessionType session, DestinationType destination, DeliveryModeType delivery, ReceiverType receiver, MessageType message, Test test) {
        boolean result = false;
        if (selector.getTest() != null && test != null) {
            result = this.containsTest(test, selector.getTest());
        }
        if (!result) {
            result = this.excludes(selector.getFactory(), factory) || this.excludes(selector.getSession(), session) || this.excludes(selector.getDestination(), destination) || this.excludes(selector.getDeliveryMode(), delivery) || this.excludes(selector.getReceiver(), receiver) || this.excludes(selector.getMessage(), message);
        }
        return result;
    }

    private boolean excludes(Object selector, Object object) {
        boolean result = false;
        if (selector != null && selector.equals(object)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("excludes(selector=" + selector + ", object=" + object + ")=" + result));
        }
        return result;
    }

    private boolean containsTest(Test test, String regexp) {
        Pattern pattern = null;
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            pattern = compiler.compile(regexp);
        }
        catch (MalformedPatternException exception) {
            log.error((Object)("Invalid test case pattern: " + exception.getMessage()));
        }
        return pattern != null ? this.containsTest(test, pattern) : false;
    }

    private boolean containsTest(Test test, Pattern pattern) {
        boolean result = false;
        if (test instanceof TestSuite) {
            Enumeration iterator = ((TestSuite)test).tests();
            while (iterator.hasMoreElements()) {
                Test contained = (Test)iterator.nextElement();
                if (!this.containsTest(contained, pattern)) continue;
                result = true;
                break;
            }
        } else if (test instanceof TestDecorator) {
            Test contained = ((TestDecorator)test).getTest();
            result = this.containsTest(contained, pattern);
        } else {
            String name = this.getTestName(test);
            result = this._matcher.matches(name, pattern);
            if (log.isDebugEnabled()) {
                log.debug((Object)("containsTest(test=" + test + ", pattern=" + pattern.getPattern() + ")=" + result));
            }
        }
        return result;
    }

    private String getTestName(Test test) {
        String name = test.getClass().getName();
        if (test instanceof TestCase) {
            name = name + "." + ((TestCase)test).getName();
        }
        return name;
    }

    static {
        FACTORIES.put(QueueConnectionFactory.class, FactoryType.QUEUECONNECTIONFACTORY);
        FACTORIES.put(TopicConnectionFactory.class, FactoryType.TOPICCONNECTIONFACTORY);
        FACTORIES.put(XAQueueConnectionFactory.class, FactoryType.XAQUEUECONNECTIONFACTORY);
        FACTORIES.put(XATopicConnectionFactory.class, FactoryType.XATOPICCONNECTIONFACTORY);
        SESSIONS = new HashMap();
        SESSIONS.put(AckTypes.TRANSACTED, SessionType.TRANSACTED);
        SESSIONS.put(AckTypes.AUTO_ACKNOWLEDGE, SessionType.AUTO_ACKNOWLEDGE);
        SESSIONS.put(AckTypes.CLIENT_ACKNOWLEDGE, SessionType.CLIENT_ACKNOWLEDGE);
        SESSIONS.put(AckTypes.DUPS_OK_ACKNOWLEDGE, SessionType.DUPS_OK_ACKNOWLEDGE);
        MESSAGES = new HashMap();
        MESSAGES.put(BytesMessage.class, MessageType.BYTESMESSAGE);
        MESSAGES.put(MapMessage.class, MessageType.MAPMESSAGE);
        MESSAGES.put(ObjectMessage.class, MessageType.OBJECTMESSAGE);
        MESSAGES.put(StreamMessage.class, MessageType.STREAMMESSAGE);
        MESSAGES.put(TextMessage.class, MessageType.TEXTMESSAGE);
        MESSAGES.put(Message.class, MessageType.MESSAGE);
    }
}

