/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Category;

public final class TestProperties {
    private static final Properties PROPS;
    private static final Category log;

    private TestProperties() {
    }

    public static String getString(Class prefix, String name, String defaultValue) {
        return TestProperties.getString(TestProperties.concat(prefix, name), defaultValue);
    }

    public static String getString(String name, String defaultValue) {
        return PROPS.getProperty(name, defaultValue);
    }

    public static int getInt(Class prefix, String name, int defaultValue) {
        return TestProperties.getInt(TestProperties.concat(prefix, name), defaultValue);
    }

    public static int getInt(String name, int defaultValue) {
        int result = defaultValue;
        String value = TestProperties.getString(name, Integer.toString(defaultValue));
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException ignore) {
            log.warn((Object)("Error parsing integer property=" + name + ", using default value"));
        }
        return result;
    }

    public static long getLong(Class prefix, String name, long defaultValue) {
        return TestProperties.getLong(TestProperties.concat(prefix, name), defaultValue);
    }

    public static long getLong(String name, long defaultValue) {
        long result = defaultValue;
        String value = TestProperties.getString(name, Long.toString(defaultValue));
        try {
            result = Long.parseLong(value);
        }
        catch (NumberFormatException ignore) {
            log.warn((Object)("Error parsing long property=" + name + ", using default value"));
        }
        return result;
    }

    private static String concat(Class prefix, String name) {
        return prefix.getName() + "." + name;
    }

    static {
        log = Category.getInstance((String)TestProperties.class.getName());
        PROPS = new Properties();
        String home = System.getProperty("jmscts.home");
        if (home == null) {
            log.warn((Object)"jmscts.home not set - not loading properties");
        } else {
            String path = home + "/config/jmscts.properties";
            try {
                File file = new File(path);
                if (file.exists()) {
                    FileInputStream stream = new FileInputStream(file);
                    PROPS.load(stream);
                } else {
                    log.warn((Object)("jmscts.properties not found: path=" + path));
                }
            }
            catch (IOException exception) {
                log.error((Object)("Failed to read " + path), (Throwable)exception);
            }
        }
    }
}

