/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.ArrayList;
import java.util.Enumeration;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.exolab.jmscts.core.JMSTest;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestFilter;

public abstract class TestRunner
extends TestSetup
implements JMSTest {
    private TestContext _context = null;
    private TestContext _child = null;
    private TestFilter _filter = null;

    public TestRunner(Test test) {
        super(test);
    }

    public void setContext(TestContext context) {
        this._context = context;
    }

    public TestContext getContext() {
        return this._context;
    }

    public void setFilter(TestFilter filter) {
        this._filter = filter;
    }

    public TestFilter getFilter() {
        return this._filter;
    }

    public boolean share() {
        return true;
    }

    public void basicRun(TestResult result) {
        Test[] tests = this.getTests();
        for (int i = 0; i < tests.length && !result.shouldStop(); ++i) {
            this.runTest(tests[i], result);
        }
    }

    protected abstract void runTest(Test var1, TestResult var2);

    protected void setChildContext(TestContext context) {
        this._child = context;
    }

    protected TestContext getChildContext() {
        return this._child;
    }

    protected void tearDown() throws Exception {
        this._context = null;
    }

    protected void checkImplements(Class type) throws Exception {
        Test[] tests = this.getTests();
        for (int i = 0; i < tests.length; ++i) {
            Test test = tests[i];
            if (type.isAssignableFrom(test.getClass())) continue;
            throw new Exception("Test " + test + " doesn't implement " + type.getName());
        }
    }

    protected Test[] getTests() {
        Test test = this.getTest();
        ArrayList result = new ArrayList();
        if (test instanceof TestSuite) {
            Enumeration iter = ((TestSuite)test).tests();
            while (iter.hasMoreElements()) {
                result.add(iter.nextElement());
            }
        } else {
            result.add(test);
        }
        return result.toArray(new Test[0]);
    }
}

