/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.JMSException;
import javax.naming.NamingException;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.exolab.jmscts.core.JMSTestCase;
import org.exolab.jmscts.core.TestStatistics;

class TestStatisticsListener
implements TestListener {
    private final TestStatistics _statistics;

    public TestStatisticsListener(TestStatistics statistics) {
        if (statistics == null) {
            throw new IllegalArgumentException("Argument statistics is null");
        }
        this._statistics = statistics;
    }

    public void addError(Test test, Throwable error) {
        if (test instanceof JMSTestCase) {
            Throwable cause = null;
            if (error instanceof JMSException) {
                cause = ((JMSException)error).getLinkedException();
            } else if (error instanceof NamingException) {
                cause = ((NamingException)error).getRootCause();
            }
            this._statistics.failed((JMSTestCase)test, error, cause);
        }
    }

    public void addFailure(Test test, AssertionFailedError error) {
        if (test instanceof JMSTestCase) {
            this._statistics.failed((JMSTestCase)test, (Throwable)error, null);
        }
    }

    public void endTest(Test test) {
        if (test instanceof JMSTestCase) {
            this._statistics.end((JMSTestCase)test);
        }
    }

    public void startTest(Test test) {
        if (test instanceof JMSTestCase) {
            this._statistics.begin((JMSTestCase)test);
        }
    }
}

