/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import org.exolab.jmscts.core.CompletionListener;

public abstract class ThreadedAction
extends Thread {
    private CompletionListener _listener = null;
    private Semaphore _completedLock = new Semaphore(0L);
    private volatile Exception _exception = null;
    private volatile long _start;
    private volatile long _end;

    public ThreadedAction() {
    }

    public ThreadedAction(CompletionListener listener) {
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._start = System.currentTimeMillis();
            this.runProtected();
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            this._end = System.currentTimeMillis();
        }
        this._completedLock.release();
        if (this._listener != null) {
            this._listener.completed();
        }
    }

    public abstract void runProtected() throws Exception;

    public long getElapsedTime() {
        return this._end - this._start;
    }

    public Exception getException() {
        return this._exception;
    }

    public void waitForCompletion() throws InterruptedException {
        this._completedLock.acquire();
        this._completedLock.release();
    }

    public boolean waitForCompletion(long timeout) throws InterruptedException {
        boolean completed = this._completedLock.attempt(timeout);
        if (completed) {
            this._completedLock.release();
        }
        return completed;
    }

    protected void setException(Exception exception) {
        this._exception = exception;
    }
}

