/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.DelegatingListener;

public class WaitingListener
extends DelegatingListener {
    private MessageListener _listener = null;
    private int _count = -1;
    private int _invoked = 0;
    private Semaphore _receiptLock = new Semaphore(0L);
    private Semaphore _processLock = new Semaphore(0L);
    private Semaphore _completedLock = new Semaphore(0L);
    private static final Category _log = Category.getInstance((Class)WaitingListener.class);

    public WaitingListener(MessageListener listener) {
        this(listener, -1);
    }

    public WaitingListener(MessageListener listener, int count) {
        super(listener);
        this._count = count;
    }

    public void waitForReceipt() throws InterruptedException {
        this._receiptLock.acquire();
    }

    public void notifyContinue() {
        this._processLock.release();
    }

    public void waitForCompletion() throws InterruptedException {
        this._completedLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        _log.debug((Object)"WaitingListener.onMessage() - begin");
        boolean fail = false;
        WaitingListener waitingListener = this;
        synchronized (waitingListener) {
            this._receiptLock.release();
            if (this._count != -1 && ++this._invoked > this._count) {
                _log.error((Object)("WaitingListener.onMessage() has been invoked too many times. Expected invocation=" + this._count + ", current invocation=" + this._invoked));
                fail = true;
            }
            if (!fail) {
                try {
                    _log.debug((Object)"WaitingListener.onMessage() - waiting");
                    this._processLock.acquire();
                    _log.debug((Object)"WaitingListener.onMessage() - done waiting");
                }
                catch (InterruptedException ignore) {
                    _log.debug((Object)"WaitingListener.onMessage() - interrupted");
                }
            }
        }
        try {
            if (!fail) {
                super.onMessage(message);
            }
        }
        catch (RuntimeException exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw exception;
        }
        finally {
            this._completedLock.release();
            _log.debug((Object)"WaitingListener.onMessage() - end");
        }
    }
}

