/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core.service;

import java.rmi.Naming;
import org.exolab.core.service.Service;
import org.exolab.core.service.ServiceException;
import org.exolab.jmscts.core.AbstractTestRunner;
import org.exolab.jmscts.core.service.SnapshotServer;

public class SnapshotService
extends Service {
    public static final String NAME = "SnapshotService";
    private AbstractTestRunner _runner = null;
    private String _name = null;
    private SnapshotServer _server = null;

    public SnapshotService(AbstractTestRunner runner, int port) {
        super(NAME);
        if (runner == null) {
            throw new IllegalArgumentException("Argument runner is null");
        }
        this._runner = runner;
        this._name = "//localhost:" + port + "/Snapshot";
    }

    public void snapshot(String path) throws Exception {
        this._runner.snapshot(path);
    }

    public synchronized void start() throws ServiceException {
        if (!this.getState().isRunning()) {
            try {
                this._server = new SnapshotServer(this);
                Naming.bind(this._name, this._server);
            }
            catch (Exception exception) {
                throw new ServiceException(exception.getMessage());
            }
        }
        super.start();
    }

    public synchronized void stop() throws ServiceException {
        super.stop();
        try {
            Naming.unbind(this._name);
            SnapshotServer.unexportObject(this._server, true);
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage());
        }
    }
}

