/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core.service;

import java.rmi.Naming;
import org.exolab.core.service.Service;
import org.exolab.core.service.ServiceException;
import org.exolab.jmscts.core.AbstractTestRunner;
import org.exolab.jmscts.core.service.TestTerminatorServer;

public class TestTerminatorService
extends Service {
    public static final String NAME = "TestTerminatorService";
    private AbstractTestRunner _runner = null;
    private String _name = null;
    private TestTerminatorServer _server = null;

    public TestTerminatorService(AbstractTestRunner runner, int port) {
        super(NAME);
        if (runner == null) {
            throw new IllegalArgumentException("Argument runner is null");
        }
        this._runner = runner;
        this._name = "//localhost:" + port + "/Terminator";
    }

    public synchronized void start() throws ServiceException {
        if (!this.getState().isRunning()) {
            try {
                this._server = new TestTerminatorServer(this);
                Naming.bind(this._name, this._server);
            }
            catch (Exception exception) {
                throw new ServiceException(exception.getMessage());
            }
        }
        super.start();
    }

    public synchronized void stop() throws ServiceException {
        super.stop();
        try {
            Naming.unbind(this._name);
            TestTerminatorServer.unexportObject(this._server, true);
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage());
        }
    }

    public void terminate(boolean abort) {
        if (abort) {
            this._runner.abort();
        } else {
            this._runner.stop();
        }
    }
}

