/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.jms.message;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.exolab.jmscts.jms.message.BasicMessage;
import org.exolab.jmscts.jms.message.FormatConverter;

public class BasicMapMessage
extends BasicMessage
implements MapMessage {
    private HashMap _map = new HashMap();

    public boolean getBoolean(String name) throws MessageFormatException {
        return FormatConverter.getBoolean(this._map.get(name));
    }

    public byte getByte(String name) throws MessageFormatException {
        return FormatConverter.getByte(this._map.get(name));
    }

    public short getShort(String name) throws MessageFormatException {
        return FormatConverter.getShort(this._map.get(name));
    }

    public char getChar(String name) throws MessageFormatException {
        return FormatConverter.getChar(this._map.get(name));
    }

    public int getInt(String name) throws MessageFormatException {
        return FormatConverter.getInt(this._map.get(name));
    }

    public long getLong(String name) throws MessageFormatException {
        return FormatConverter.getLong(this._map.get(name));
    }

    public float getFloat(String name) throws MessageFormatException {
        return FormatConverter.getFloat(this._map.get(name));
    }

    public double getDouble(String name) throws MessageFormatException {
        return FormatConverter.getDouble(this._map.get(name));
    }

    public String getString(String name) throws MessageFormatException {
        return FormatConverter.getString(this._map.get(name));
    }

    public byte[] getBytes(String name) throws MessageFormatException {
        return FormatConverter.getBytes(this._map.get(name));
    }

    public Object getObject(String name) throws JMSException {
        Object result = this._map.get(name);
        if (result instanceof byte[]) {
            result = this.getBytes(name);
        }
        return result;
    }

    public Enumeration getMapNames() {
        return Collections.enumeration(this._map.keySet());
    }

    public void setBoolean(String name, boolean value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Boolean(value));
    }

    public void setByte(String name, byte value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Byte(value));
    }

    public void setShort(String name, short value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Short(value));
    }

    public void setChar(String name, char value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Character(value));
    }

    public void setInt(String name, int value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Long(value));
    }

    public void setFloat(String name, float value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Double(value));
    }

    public void setString(String name, String value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws MessageNotWriteableException {
        this.checkWrite();
        byte[] bytes = null;
        if (value != null) {
            bytes = new byte[value.length];
            System.arraycopy(value, 0, bytes, 0, bytes.length);
        }
        this._map.put(name, bytes);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws MessageNotWriteableException {
        this.checkWrite();
        byte[] bytes = null;
        if (value != null) {
            bytes = new byte[length];
            System.arraycopy(value, offset, bytes, 0, length);
        }
        this._map.put(name, bytes);
    }

    public void setObject(String name, Object value) throws MessageFormatException, MessageNotWriteableException {
        if (value == null) {
            this.checkWrite();
            this._map.put(name, null);
        } else if (value instanceof Boolean) {
            this.setBoolean(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(name, (Short)value);
        } else if (value instanceof Character) {
            this.setChar(name, ((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else if (value instanceof byte[]) {
            this.setBytes(name, (byte[])value);
        } else {
            throw new MessageFormatException("MapMessage does not support objects of type=" + value.getClass().getName());
        }
    }

    public boolean itemExists(String name) {
        return this._map.containsKey(name);
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._map = new HashMap();
    }
}

