/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.jms.message;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.exolab.jmscts.jms.message.FormatConverter;

public class BasicMessage
implements Message {
    private boolean _propertiesReadOnly = false;
    private boolean _bodyReadOnly = false;
    private String _messageID;
    private String _type;
    private long _timestamp;
    private String _correlationID;
    private byte[] _correlationIDBytes;
    private Destination _destination;
    private Destination _replyTo;
    private int _deliveryMode;
    private long _expiration;
    private int _priority;
    private boolean _redelivered;
    private HashMap _properties = new HashMap();

    public void acknowledge() {
    }

    public void clearBody() throws JMSException {
        this._bodyReadOnly = false;
    }

    public void clearProperties() {
        this._properties.clear();
        this._propertiesReadOnly = false;
    }

    public String getJMSMessageID() {
        return this._messageID;
    }

    public void setJMSMessageID(String messageID) {
        this._messageID = messageID;
    }

    public String getJMSType() {
        return this._type;
    }

    public void setJMSType(String type) {
        this._type = type;
    }

    public long getJMSTimestamp() {
        return this._timestamp;
    }

    public void setJMSTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public String getJMSCorrelationID() {
        return this._correlationID;
    }

    public void setJMSCorrelationID(String correlationID) {
        this._correlationID = correlationID;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this._correlationIDBytes;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this._correlationIDBytes = correlationID;
    }

    public Destination getJMSDestination() {
        return this._destination;
    }

    public void setJMSDestination(Destination destination) {
        this._destination = destination;
    }

    public Destination getJMSReplyTo() {
        return this._replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) {
        this._replyTo = replyTo;
    }

    public int getJMSDeliveryMode() {
        return this._deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this._deliveryMode = deliveryMode;
    }

    public long getJMSExpiration() {
        return this._expiration;
    }

    public void setJMSExpiration(long expiration) {
        this._expiration = expiration;
    }

    public int getJMSPriority() {
        return this._priority;
    }

    public void setJMSPriority(int priority) {
        this._priority = priority;
    }

    public boolean getJMSRedelivered() {
        return this._redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) {
        this._redelivered = redelivered;
    }

    public boolean propertyExists(String name) {
        return this._properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws MessageFormatException {
        return FormatConverter.getBoolean(this._properties.get(name));
    }

    public void setBooleanProperty(String name, boolean value) {
        this._properties.put(name, new Boolean(value));
    }

    public byte getByteProperty(String name) throws MessageFormatException {
        return FormatConverter.getByte(this._properties.get(name));
    }

    public void setByteProperty(String name, byte value) {
        this._properties.put(name, new Byte(value));
    }

    public short getShortProperty(String name) throws MessageFormatException {
        return FormatConverter.getShort(this._properties.get(name));
    }

    public void setShortProperty(String name, short value) {
        this._properties.put(name, new Short(value));
    }

    public int getIntProperty(String name) throws MessageFormatException {
        return FormatConverter.getInt(this._properties.get(name));
    }

    public void setIntProperty(String name, int value) {
        this._properties.put(name, new Integer(value));
    }

    public long getLongProperty(String name) throws MessageFormatException {
        return FormatConverter.getLong(this._properties.get(name));
    }

    public void setLongProperty(String name, long value) {
        this._properties.put(name, new Long(value));
    }

    public float getFloatProperty(String name) throws MessageFormatException {
        return FormatConverter.getFloat(this._properties.get(name));
    }

    public void setFloatProperty(String name, float value) {
        this._properties.put(name, new Float(value));
    }

    public double getDoubleProperty(String name) throws MessageFormatException {
        return FormatConverter.getDouble(this._properties.get(name));
    }

    public void setDoubleProperty(String name, double value) {
        this._properties.put(name, new Double(value));
    }

    public String getStringProperty(String name) throws MessageFormatException {
        return FormatConverter.getString(this._properties.get(name));
    }

    public void setStringProperty(String name, String value) {
        this._properties.put(name, value);
    }

    public Object getObjectProperty(String name) {
        return this._properties.get(name);
    }

    public void setObjectProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    public Enumeration getPropertyNames() {
        return Collections.enumeration(this._properties.keySet());
    }

    public void setReadOnly(boolean readOnly) throws JMSException {
        this._propertiesReadOnly = readOnly;
        this._bodyReadOnly = readOnly;
    }

    protected boolean getPropertiesReadOnly() {
        return this._propertiesReadOnly;
    }

    protected void setPropertiesReadOnly(boolean readOnly) {
        this._propertiesReadOnly = readOnly;
    }

    protected boolean getBodyReadOnly() {
        return this._bodyReadOnly;
    }

    protected void setBodyReadOnly(boolean readOnly) {
        this._bodyReadOnly = readOnly;
    }

    protected void checkPropertyWrite() throws MessageNotWriteableException {
        if (this._propertiesReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    protected void checkWrite() throws MessageNotWriteableException {
        if (this._bodyReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    protected void checkRead() throws MessageNotReadableException {
        if (!this._bodyReadOnly) {
            throw new MessageNotReadableException("Message in write-only mode");
        }
    }
}

