/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.jmscts.report.TestRuns;
import org.xml.sax.ContentHandler;

public class Statistics
implements Serializable {
    private String _provider;
    private ArrayList _testRunsList = new ArrayList();

    public void addTestRuns(TestRuns vTestRuns) throws IndexOutOfBoundsException {
        this._testRunsList.add(vTestRuns);
    }

    public void addTestRuns(int index, TestRuns vTestRuns) throws IndexOutOfBoundsException {
        this._testRunsList.add(index, vTestRuns);
    }

    public void clearTestRuns() {
        this._testRunsList.clear();
    }

    public Enumeration enumerateTestRuns() {
        return new IteratorEnumeration(this._testRunsList.iterator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Statistics) {
            Statistics temp = (Statistics)obj;
            if (this._provider != null) {
                if (temp._provider == null) {
                    return false;
                }
                if (!this._provider.equals(temp._provider)) {
                    return false;
                }
            } else if (temp._provider != null) {
                return false;
            }
            if (this._testRunsList != null) {
                if (temp._testRunsList == null) {
                    return false;
                }
                if (!this._testRunsList.equals(temp._testRunsList)) {
                    return false;
                }
            } else if (temp._testRunsList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getProvider() {
        return this._provider;
    }

    public TestRuns getTestRuns(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._testRunsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (TestRuns)this._testRunsList.get(index);
    }

    public TestRuns[] getTestRuns() {
        int size = this._testRunsList.size();
        TestRuns[] mArray = new TestRuns[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (TestRuns)this._testRunsList.get(index);
        }
        return mArray;
    }

    public int getTestRunsCount() {
        return this._testRunsList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeTestRuns(TestRuns vTestRuns) {
        boolean removed = this._testRunsList.remove(vTestRuns);
        return removed;
    }

    public void setProvider(String provider) {
        this._provider = provider;
    }

    public void setTestRuns(int index, TestRuns vTestRuns) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._testRunsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._testRunsList.set(index, vTestRuns);
    }

    public void setTestRuns(TestRuns[] testRunsArray) {
        this._testRunsList.clear();
        for (int i = 0; i < testRunsArray.length; ++i) {
            this._testRunsList.add(testRunsArray[i]);
        }
    }

    public static Statistics unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Statistics)Unmarshaller.unmarshal((Class)Statistics.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

