/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.jmscts.core.TestStatistics;
import org.exolab.jmscts.provider.ProviderLoader;
import org.exolab.jmscts.report.Statistics;
import org.exolab.jmscts.report.TransformerHelper;

public class StatisticsReport {
    private String _path;
    private TestStatistics _statistics;
    private ProviderLoader _provider;
    private static final Category log = Category.getInstance((Class)StatisticsReport.class);
    private static final String STATISTICS_XML = "statistics.xml";
    private static final String XDOC_XML = "statistics-xdoc.xml";
    private static final String STATISTICS_HTML = "statistics.html";
    private static final String STATS_STYLESHEET = "resources/statistics.xsl";

    public StatisticsReport(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        this._path = path;
    }

    public StatisticsReport(String path, TestStatistics statistics, ProviderLoader provider) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        if (statistics == null) {
            throw new IllegalArgumentException("Argument 'statistics' is null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 'provider' is null");
        }
        this._path = path;
        this._statistics = statistics;
        this._provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String dir) throws IOException, MarshalException, TransformerException, ValidationException {
        if (this._statistics != null) {
            Statistics statistics = this._statistics.getStatistics();
            statistics.setProvider(this._provider.getName());
            String path = dir + "/" + STATISTICS_XML;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Writing statistics report to " + path));
            }
            FileWriter stream = new FileWriter(path);
            try {
                statistics.marshal(stream);
            }
            finally {
                stream.close();
            }
        }
        this.transform(dir);
    }

    private void transform(String dir) throws IOException, TransformerException {
        File input = new File(dir, STATISTICS_XML);
        File xdoc = new File(dir, XDOC_XML);
        File baseDir = new File(this._path);
        File stylesheet = new File(baseDir, STATS_STYLESHEET);
        File html = new File(dir, STATISTICS_HTML);
        TransformerHelper.transform(input, xdoc, stylesheet);
        TransformerHelper.transformXDoc2HTML(xdoc, html, baseDir);
    }

    public static void main(String[] args) throws Exception {
        String path = "path";
        Options options = new Options();
        options.addOption("path", true, "the output path");
        GnuParser parser = new GnuParser();
        CommandLine commands = parser.parse(options, args);
        String dir = commands.getOptionValue("path");
        if (dir == null) {
            throw new Exception("-path <path> parameter not set");
        }
        StatisticsReport report = new StatisticsReport("./");
        report.report(dir);
    }
}

