/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.requirements;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.jmscts.requirements.Document;
import org.exolab.jmscts.requirements.Include;
import org.exolab.jmscts.requirements.Reference;
import org.exolab.jmscts.requirements.Requirement;
import org.exolab.jmscts.requirements.Requirements;

public final class RequirementsLoader {
    private static final String PATH = "/org/exolab/jmscts/requirements/";
    private static final String FILE = "/org/exolab/jmscts/requirements/requirements.xml";

    private RequirementsLoader() {
    }

    public static Requirements load() throws FileNotFoundException, MarshalException, ValidationException {
        Requirements result = new Requirements();
        RequirementsLoader.add(result, RequirementsLoader.getResourceAsStream(FILE));
        return result;
    }

    private static void add(Requirements result, InputStreamReader stream) throws FileNotFoundException, MarshalException, ValidationException {
        Requirement[] requirements;
        Reference[] references;
        Document source = Document.unmarshal(stream);
        Include[] includes = source.getInclude();
        if (includes != null) {
            for (int i = 0; i < includes.length; ++i) {
                Include include = includes[i];
                String path = PATH + include.getPath();
                RequirementsLoader.add(result, RequirementsLoader.getResourceAsStream(path));
            }
        }
        if ((references = source.getReference()) != null) {
            for (int i = 0; i < references.length; ++i) {
                result.addReference(references[i]);
            }
        }
        if ((requirements = source.getRequirement()) != null) {
            for (int i = 0; i < requirements.length; ++i) {
                result.addRequirement(requirements[i]);
            }
        }
    }

    private static InputStreamReader getResourceAsStream(String path) throws FileNotFoundException {
        InputStream stream = RequirementsLoader.class.getResourceAsStream(path);
        if (stream == null) {
            throw new FileNotFoundException("Cannot locate resource: " + path);
        }
        return new InputStreamReader(stream);
    }
}

