/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.stress;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.CountingListener;
import org.exolab.jmscts.core.MessageCreator;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.core.TestProperties;
import org.exolab.jmscts.core.TestStatistics;
import org.exolab.jmscts.core.ThreadedReceiver;
import org.exolab.jmscts.core.ThreadedSender;
import org.exolab.jmscts.report.types.StatisticType;
import org.exolab.jmscts.stress.AckingListener;

public class ReceiveSize0KTest
extends AbstractSendReceiveTestCase {
    private static final Category LOG = Category.getInstance((Class)ReceiveSize0KTest.class);
    private static final String DESTINATION = "ReceiveSize0KTest";

    public ReceiveSize0KTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ReceiveSize0KTest.class);
    }

    public boolean shouldCreateMessage() {
        return false;
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void test() throws Exception {
        int defaultCount = 1000;
        int count = TestProperties.getInt(this.getClass(), "count", 1000);
        TestContext context = this.getContext();
        Session session = context.getSession();
        MessageCreator creator = new MessageCreator(session, null);
        Class messageType = context.getMessageType();
        Destination destination = this.getDestination(DESTINATION);
        MessageSender sender = SessionHelper.createSender(context, destination);
        MessageReceiver receiver = SessionHelper.createReceiver(context, destination);
        AckType ack = context.getAckType();
        CountingListener listener = ack.getAcknowledgeMode() == 2 ? new AckingListener(count) : new CountingListener(count);
        TestStatistics stats = context.getStatistics();
        Message message = creator.create(messageType);
        ThreadedSender send = new ThreadedSender(sender, message, count);
        ThreadedReceiver receive = new ThreadedReceiver(receiver, 0L, listener);
        send.run();
        if (send.getException() != null) {
            throw send.getException();
        }
        receive.run();
        if (receive.getException() != null) {
            throw receive.getException();
        }
        int received = listener.getReceived();
        ReceiveSize0KTest.assertEquals((String)("Expected " + count + " messages to be received, but got " + received), (int)count, (int)received);
        stats.log(StatisticType.RECEIVE, count, receive.getElapsedTime());
        receiver.remove();
    }
}

