/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.asf;

import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.CountingListener;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.jms.asf.BasicServerSessionPool;

public class ConnectionConsumerTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "ConnectionConsumerTest";
    private static final Category log = Category.getInstance((String)ConnectionConsumerTest.class.getName());

    public ConnectionConsumerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ConnectionConsumerTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        boolean maxMessages = true;
        boolean threads = true;
        int count = 10;
        TestContext context = this.getContext();
        AckType type = context.getAckType();
        MessagingBehaviour behaviour = context.getMessagingBehaviour();
        Destination destination = this.getDestination(DESTINATION);
        CountingListener listener = new CountingListener(10);
        BasicServerSessionPool pool = new BasicServerSessionPool(1, context.getConnection(), type.getTransacted(), type.getAcknowledgeMode(), listener);
        ConnectionConsumer consumer = null;
        try {
            consumer = ConnectionHelper.createConnectionConsumer(context, destination, null, null, pool, 1);
            this.send(destination, 10);
            listener.waitForCompletion(10L * behaviour.getTimeout());
            if (listener.getReceived() != 10) {
                ConnectionConsumerTest.fail((String)("Expected 10 messages from destination=" + DestinationHelper.getName(destination) + " but got " + listener.getReceived()));
            }
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
            pool.close();
        }
    }
}

