/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.connection;

import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractConnectionFactoryTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.core.TestProperties;

public class AuthTest
extends AbstractConnectionFactoryTestCase {
    public AuthTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createConnectionFactoryTest(AuthTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueueAuth() throws Exception {
        TestContext context = this.getContext();
        QueueConnectionFactory factory = (QueueConnectionFactory)context.getConnectionFactory();
        QueueConnection connection = null;
        String user = TestProperties.getString("valid.username", "CHANGE_ME");
        String password = TestProperties.getString("valid.password", "CHANGE_ME");
        try {
            connection = factory.createQueueConnection(user, password);
            AuthTest.assertNotNull((String)"QueueConnection is null", (Object)connection);
        }
        catch (JMSException exception) {
            AuthTest.fail((String)("Expected creation of QueueConnection to succeed with username=" + user + ", password=" + password));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidQueueAuth() throws Exception {
        TestContext context = this.getContext();
        QueueConnectionFactory factory = (QueueConnectionFactory)context.getConnectionFactory();
        QueueConnection connection = null;
        String user = TestProperties.getString("invalid.username", "CHANGE_ME");
        String password = TestProperties.getString("invalid.password", "CHANGE_ME");
        try {
            connection = factory.createQueueConnection(user, password);
            AuthTest.fail((String)("Expected creation of QueueConnection to fail with username=" + user + ", password=" + password));
        }
        catch (JMSSecurityException ignore) {
        }
        catch (JMSException exception) {
            AuthTest.fail((String)("Expected JMSSecurityException to be thrown, but got exception type=" + ((Object)((Object)exception)).getClass().getName() + ": " + (Object)((Object)exception)));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTopicAuth() throws Exception {
        TestContext context = this.getContext();
        TopicConnectionFactory factory = (TopicConnectionFactory)context.getConnectionFactory();
        TopicConnection connection = null;
        String user = TestProperties.getString("valid.username", "CHANGE_ME");
        String password = TestProperties.getString("valid.password", "CHANGE_ME");
        try {
            connection = factory.createTopicConnection(user, password);
            AuthTest.assertNotNull((String)"TopicConnection is null", (Object)connection);
        }
        catch (JMSException exception) {
            AuthTest.fail((String)("Expected creation of TopicConnection to succeed with user=" + user + ", password=" + password));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidTopicAuth() throws Exception {
        TestContext context = this.getContext();
        TopicConnectionFactory factory = (TopicConnectionFactory)context.getConnectionFactory();
        TopicConnection connection = null;
        String user = TestProperties.getString("invalid.username", "CHANGE_ME");
        String password = TestProperties.getString("invalid.password", "CHANGE_ME");
        try {
            connection = factory.createTopicConnection(user, password);
            AuthTest.fail((String)("Expected creation of TopicConnection to fail with user=" + user + ", password=" + password));
        }
        catch (JMSSecurityException ignore) {
        }
        catch (JMSException exception) {
            AuthTest.fail((String)("Expected JMSSecurityException to be thrown, but got exception type=" + ((Object)((Object)exception)).getClass().getName() + ": " + (Object)((Object)exception)));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

