/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.connection;

import java.util.Enumeration;
import java.util.HashSet;
import javax.jms.ConnectionMetaData;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractConnectionTestCase;
import org.exolab.jmscts.core.TestCreator;

public class MetaDataTest
extends AbstractConnectionTestCase {
    private static final String GROUP_ID = "JMSXGroupID";
    private static final String GROUP_SEQ = "JMSXGroupSeq";

    public MetaDataTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createConnectionTest(MetaDataTest.class);
    }

    public void testMetaData() throws Exception {
        ConnectionMetaData metaData = this.getContext().getConnection().getMetaData();
        if (metaData == null) {
            MetaDataTest.fail((String)"Connection returned null for getMetaData()");
        }
        HashSet<String> names = new HashSet<String>();
        Enumeration iter = metaData.getJMSXPropertyNames();
        while (iter.hasMoreElements()) {
            names.add((String)iter.nextElement());
        }
        if (!names.contains(GROUP_ID)) {
            MetaDataTest.fail((String)"ConnectionMetaData does not support JMSXGroupID");
        }
        if (!names.contains(GROUP_SEQ)) {
            MetaDataTest.fail((String)"ConnectionMetaData does not support JMSXGroupSeq");
        }
    }
}

