/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.connection;

import java.util.List;
import javax.jms.Connection;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.CompletionListener;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.DelayedAction;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.core.ThreadedActions;
import org.exolab.jmscts.core.ThreadedReceiver;

public class ReceiverTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "ReceiverTest";
    private static final Category log = Category.getInstance((Class)ReceiverTest.class);

    public ReceiverTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ReceiverTest.class);
    }

    public boolean share() {
        return false;
    }

    public boolean startConnection() {
        return false;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionStop() throws Exception {
        int delayTime = 500;
        int receiptTime = 5000;
        TestContext context = this.getContext();
        final Connection connection = context.getConnection();
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        DelayedAction action = new DelayedAction(500L){

            public void runProtected() throws Exception {
                connection.stop();
            }
        };
        try {
            connection.start();
            action.start();
            try {
                List result = receiver.receive(0, 5000L);
            }
            catch (Exception exception) {
                ReceiverTest.fail((String)("Expected synchronous consumer to time out and return null when connection stopped, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
            Exception exception = action.getException();
            if (exception != null) {
                ReceiverTest.fail((String)("Failed to stop connection, exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
        }
        finally {
            try {
                receiver.remove();
            }
            catch (Exception exception) {
                ReceiverTest.fail((String)("Attempting to invoke close() for a consumer on a stopped connection threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
        }
    }

    public void testConnectionClose() throws Exception {
        Exception exception;
        int delayTime = 1000;
        int completionTime = 30000;
        TestContext context = this.getContext();
        final Connection connection = context.getConnection();
        final MessageReceiver receiver = this.createReceiver(DESTINATION);
        CompletionListener listener = new CompletionListener(2);
        DelayedAction receive = new DelayedAction(0L, listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runProtected() throws Exception {
                try {
                    log.debug((Object)"Receiver starting");
                    receiver.receive(0, 0L);
                }
                finally {
                    log.debug((Object)"Receiver terminating");
                }
            }
        };
        DelayedAction close = new DelayedAction(1000L, listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runProtected() throws Exception {
                try {
                    log.debug((Object)"Connection closing");
                    connection.close();
                }
                finally {
                    log.debug((Object)"Connection closed");
                }
            }
        };
        connection.start();
        receive.start();
        close.start();
        listener.waitForCompletion(30000L);
        if (listener.getCompleted() != 2) {
            context.invalidate();
            ReceiverTest.fail((String)"Connection.close() didn't force consumer's receive() to be terminated and return null. Appears to have blocked");
        }
        if (receive.getException() != null) {
            context.invalidate();
            exception = receive.getException();
            ReceiverTest.fail((String)("Expected synchronous consumer's receive() to be terminated and return null when connection closed, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        if (close.getException() != null) {
            context.invalidate();
            exception = close.getException();
            ReceiverTest.fail((String)("Closing connection while a synchronous receive() in progress threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        try {
            receiver.close();
        }
        catch (Exception exception2) {
            ReceiverTest.fail((String)("Attempting to invoke close() for a consumer on a closed connection threw exception=" + exception2.getClass().getName() + ", message=" + exception2.getMessage()));
        }
    }

    public void testConnectionRestart() throws Exception {
        List messages;
        Exception exception;
        int delayTime = 1000;
        int completionTime = 30000;
        final TestContext context = this.getContext();
        final Connection connection = context.getConnection();
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        ThreadedReceiver receive = new ThreadedReceiver(receiver, 1, 0L);
        DelayedAction restart = new DelayedAction(1000L){

            public void runProtected() throws Exception {
                connection.stop();
                connection.start();
                Session session = ConnectionHelper.createSession(context);
                TestContext tmp = new TestContext(context, session, context.getAckType());
                TestContext local = new TestContext(tmp, context.getMessage(), context.getMessagingBehaviour());
                ReceiverTest.this.send(local, ReceiverTest.DESTINATION, 1);
            }
        };
        ThreadedActions actions = new ThreadedActions();
        actions.addAction(receive);
        actions.addAction(restart);
        connection.start();
        actions.start();
        boolean completed = actions.waitForCompletion(30000L);
        if (!completed) {
            context.invalidate();
            ReceiverTest.fail((String)"Receiver didn't return a message after connection restart. Appears to have blocked");
        }
        if (receive.getException() != null) {
            context.invalidate();
            exception = receive.getException();
            ReceiverTest.fail((String)("Expected synchronous consumer to return a message after connection was restarted, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        if (restart.getException() != null) {
            context.invalidate();
            exception = receive.getException();
            ReceiverTest.fail((String)("Failure in restarting connection, exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        if ((messages = receive.getMessages()) == null) {
            ReceiverTest.fail((String)"Failed to receive any messages from the destination after the connection was restarted");
        }
        receiver.remove();
    }
}

