/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.bytes;

import java.math.BigDecimal;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.MessageFormatException;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.MessageValues;

public class BytesMessageTest
extends AbstractMessageTestCase
implements MessageValues {
    public BytesMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(BytesMessageTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testReadFailure() throws Exception {
        int count;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        int illegalChar = -1;
        byte[] invalidUTF = new byte[]{0, 1, -1};
        message.writeBytes(invalidUTF);
        message.reset();
        try {
            message.readUTF();
            BytesMessageTest.fail((String)"Expected MessageFormatException to be thrown for invalid UTF string");
        }
        catch (MessageFormatException expected) {
        }
        catch (Exception exception) {
            BytesMessageTest.fail((String)("Expected MessageFormatException to be thrown for invalid UTF string, but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        byte[] buffer = new byte[invalidUTF.length];
        message.readBytes(buffer);
        if (!Arrays.equals(invalidUTF, buffer)) {
            BytesMessageTest.fail((String)"Byte array does not match that written");
        }
        if ((count = message.readBytes(buffer)) != -1) {
            BytesMessageTest.fail((String)("Expected readBytes(byte[]) to return count=-1 to indicate end-of-stream, but returned count=" + count));
        }
    }

    public void testReadBytesForEmptyStream1() throws Exception {
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        message.reset();
        this.checkEndOfStream1(message);
    }

    public void testReadBytesForEmptyStream2() throws Exception {
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        message.reset();
        this.checkEndOfStream2(message);
    }

    public void testReadBytes() throws Exception {
        int size = 256;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer1 = new byte[bytes.length];
        this.checkReadBytes1(message, buffer1, bytes);
        this.checkEndOfStream1(message);
        message.reset();
        byte[] buffer2 = new byte[bytes.length / 2];
        this.checkReadBytes1(message, buffer2, this.populateByteArray(buffer2.length, 0));
        this.checkReadBytes1(message, buffer2, this.populateByteArray(buffer2.length, buffer2.length));
        this.checkEndOfStream1(message);
        message.reset();
        byte[] buffer3 = new byte[bytes.length * 2];
        this.checkReadBytes1(message, buffer3, bytes);
        this.checkEndOfStream1(message);
    }

    public void testPartialReadBytes1() throws Exception {
        int size = 256;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        int chunkSize = 8;
        int chunks = bytes.length / 8;
        message.writeBytes(bytes);
        message.reset();
        byte[] readBytes = new byte[bytes.length];
        byte[] buffer = new byte[8];
        for (int i = 0; i < chunks; ++i) {
            this.checkReadBytes2(message, buffer, buffer.length);
            System.arraycopy(buffer, 0, readBytes, i * 8, 8);
        }
        if (!Arrays.equals(bytes, readBytes)) {
            BytesMessageTest.fail((String)"Byte array does not match that written");
        }
        this.checkEndOfStream2(message);
    }

    public void testPartialReadBytes2() throws Exception {
        int size = 256;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        int chunkSize = 8;
        int chunks = bytes.length / 8;
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        byte[] readBytes = new byte[bytes.length];
        for (int i = 0; i < chunks; ++i) {
            this.checkReadBytes2(message, buffer, 8);
            System.arraycopy(buffer, 0, readBytes, i * 8, 8);
        }
        if (!Arrays.equals(bytes, readBytes)) {
            BytesMessageTest.fail((String)"Byte array does not match that written");
        }
        this.checkEndOfStream2(message);
    }

    public void testReadBytesIndexException() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        byte[] buffer = new byte[10];
        message.reset();
        try {
            message.readBytes(buffer, -1);
            BytesMessageTest.fail((String)"BytesMessage.readBytes(byte[], int) should throw IndexOutOfBoundsException for negative length parameter");
        }
        catch (IndexOutOfBoundsException expected) {
        }
        catch (Exception exception) {
            BytesMessageTest.fail((String)("BytesMessage.readBytes(byte[], int) should throw IndexOutOfBoundsException for negative length parameter but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        try {
            message.readBytes(buffer, buffer.length + 1);
            BytesMessageTest.fail((String)"BytesMessage.readBytes(byte[], int) should throw IndexOutOfBoundsException for invalid length parameter");
        }
        catch (IndexOutOfBoundsException expected) {
        }
        catch (Exception exception) {
            BytesMessageTest.fail((String)("BytesMessage.readBytes(byte[], int) should throw IndexOutOfBoundsException for invalid length parameter but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }

    public void testWriteObject() throws Exception {
        int size = 256;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        message.writeObject((Object)Boolean.TRUE);
        message.writeObject((Object)new Byte(127));
        message.writeObject((Object)new Character('\uffff'));
        message.writeObject((Object)new Short(Short.MAX_VALUE));
        message.writeObject((Object)new Integer(Integer.MAX_VALUE));
        message.writeObject((Object)new Float(Float.MAX_VALUE));
        message.writeObject((Object)new Double(Double.MAX_VALUE));
        String utf = "ABCD";
        message.writeObject((Object)utf);
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeObject((Object)bytes);
        message.reset();
        BytesMessageTest.assertEquals((boolean)true, (boolean)message.readBoolean());
        BytesMessageTest.assertEquals((byte)127, (byte)message.readByte());
        BytesMessageTest.assertEquals((char)'\uffff', (char)message.readChar());
        BytesMessageTest.assertEquals((short)Short.MAX_VALUE, (short)message.readShort());
        BytesMessageTest.assertEquals((int)Integer.MAX_VALUE, (int)message.readInt());
        BytesMessageTest.assertEquals((double)3.4028234663852886E38, (double)message.readFloat(), (double)0.0);
        BytesMessageTest.assertEquals((double)Double.MAX_VALUE, (double)message.readDouble(), (double)0.0);
        BytesMessageTest.assertEquals((String)utf, (String)message.readUTF());
        byte[] buffer = new byte[bytes.length];
        message.readBytes(buffer);
        BytesMessageTest.assertTrue((boolean)Arrays.equals(bytes, buffer));
        this.checkEndOfStream1(message);
        this.checkEndOfStream2(message);
    }

    public void testInvalidObject() throws Exception {
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        try {
            message.writeObject((Object)new BigDecimal(0.0));
            BytesMessageTest.fail((String)"BytesMessage.writeObject() should only support objectified primitives");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    private byte[] populateByteArray(int length, int start) {
        byte[] result = new byte[length];
        byte j = (byte)start;
        int i = 0;
        while (i < length) {
            result[i] = j;
            ++i;
            j = (byte)(j + 1);
        }
        return result;
    }

    private void checkReadBytes1(BytesMessage message, byte[] buffer, byte[] expected) throws Exception {
        int count = message.readBytes(buffer);
        if (count != expected.length) {
            BytesMessageTest.fail((String)("Expected readBytes(byte[]) to return count=" + expected.length + " but returned count=" + count));
        }
        if (buffer.length > expected.length) {
            byte[] tmp = new byte[expected.length];
            System.arraycopy(buffer, 0, tmp, 0, tmp.length);
            buffer = tmp;
        }
        if (!Arrays.equals(expected, buffer)) {
            BytesMessageTest.fail((String)"Byte array read by readBytes(byte[]) is different to that written");
        }
    }

    private void checkEndOfStream1(BytesMessage message) throws Exception {
        int size = 10;
        byte[] buffer = new byte[10];
        try {
            for (int i = 0; i < 2; ++i) {
                int count = message.readBytes(buffer);
                if (count == -1) continue;
                BytesMessageTest.fail((String)("Expected readBytes(byte[]) to return count=-1 to indicate end-of-stream, but returned count=" + count));
            }
        }
        catch (Exception exception) {
            BytesMessageTest.fail((String)("Expected readBytes(byte[]) to return count=-1 to indicate end-of-stream, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }

    private void checkReadBytes2(BytesMessage message, byte[] buffer, int length) throws Exception {
        int count = message.readBytes(buffer, length);
        if (count != length) {
            BytesMessageTest.fail((String)("Expected readBytes(byte[], int) to return count=" + length + " but returned count=" + count));
        }
    }

    private void checkEndOfStream2(BytesMessage message) throws Exception {
        int size = 10;
        byte[] buffer = new byte[10];
        try {
            for (int i = 0; i < 2; ++i) {
                int count = message.readBytes(buffer, buffer.length);
                if (count == -1) continue;
                BytesMessageTest.fail((String)("Expected readBytes(byte[], int) to return count=-1to indicate end-of-stream, but returned count=" + count));
            }
        }
        catch (Exception exception) {
            BytesMessageTest.fail((String)("Expected readBytes(byte[], int) to return count=-1 to indicate end-of-stream, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }
}

