/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.clear;

import java.util.Iterator;
import java.util.List;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessageVerifier;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;
import org.exolab.jmscts.test.message.util.MessagePropertyVerifier;
import org.exolab.jmscts.test.message.util.PopulatorVerifierFactory;

public class RollbackClearTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "RollbackClearTest";

    public RollbackClearTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(RollbackClearTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRollback() throws Exception {
        int count = 2;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        MessagePropertyVerifier properties = new MessagePropertyVerifier();
        MessagePopulatorVerifier body = PopulatorVerifierFactory.create(message);
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            MessageSender sender = this.createSender(DESTINATION);
            for (int i = 0; i < 2; ++i) {
                message.clearProperties();
                ((MessagePopulatorVerifier)properties).populate(message);
                message.clearBody();
                body.populate(message);
                sender.send(message, 1);
            }
            Session session = context.getSession();
            session.commit();
            List messages = this.verify(receiver, properties, body, 2);
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                Message received = (Message)iter.next();
                message.clearProperties();
                message.clearBody();
            }
            session.rollback();
            this.verify(receiver, properties, body, 2);
            session.commit();
        }
        finally {
            receiver.remove();
        }
    }

    private List verify(MessageReceiver receiver, MessageVerifier properties, MessageVerifier body, int count) throws Exception {
        List messages = this.receive(receiver, count);
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            Message received = (Message)iter.next();
            properties.verify(received);
            body.verify(received);
        }
        return messages;
    }
}

