/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.clear;

import java.util.Iterator;
import java.util.List;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageVerifier;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.clear.ClearHelper;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;
import org.exolab.jmscts.test.message.util.MessagePropertyVerifier;
import org.exolab.jmscts.test.message.util.PopulatorVerifierFactory;

public class SendReceiveClearTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "SendReceiveClearTest";

    public SendReceiveClearTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(SendReceiveClearTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testClearPropertiesOnReceipt() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        MessagePropertyVerifier properties = new MessagePropertyVerifier();
        ((MessagePopulatorVerifier)properties).populate(message);
        MessagePopulatorVerifier body = PopulatorVerifierFactory.create(message);
        body.populate(message);
        Message received = this.sendReceive(message, DESTINATION);
        ClearHelper.checkClearProperties(received, body, true);
    }

    public void testClearBodyOnReceipt() throws Exception {
        this.checkClearBodyOnReceipt();
    }

    public void testBytesClearBodyOnReceipt() throws Exception {
        this.checkClearBodyOnReceipt();
    }

    public void testStreamClearBodyOnReceipt() throws Exception {
        this.checkClearBodyOnReceipt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearOnSend() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        MessagePropertyVerifier properties = new MessagePropertyVerifier();
        MessagePopulatorVerifier body = PopulatorVerifierFactory.create(message);
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            MessageSender sender = this.createSender(DESTINATION);
            for (int i = 0; i < 10; ++i) {
                message.clearProperties();
                ((MessagePopulatorVerifier)properties).populate(message);
                message.clearBody();
                body.populate(message);
                sender.send(message, 1);
            }
            Session session = context.getSession();
            if (session.getTransacted()) {
                session.commit();
            }
            List messages = this.receive(receiver, 10);
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                Message received = (Message)iter.next();
                ((AbstractMessageVerifier)properties).verify(received);
                body.verify(received);
            }
        }
        finally {
            receiver.remove();
        }
    }

    private void checkClearBodyOnReceipt() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        MessagePropertyVerifier properties = new MessagePropertyVerifier();
        MessagePopulatorVerifier body = PopulatorVerifierFactory.create(message);
        ((MessagePopulatorVerifier)properties).populate(message);
        body.populate(message);
        Message received = this.sendReceive(message, DESTINATION);
        ClearHelper.checkClearBody(received, properties);
    }
}

