/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.close;

import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;
import org.exolab.jmscts.test.message.util.PopulatorVerifierFactory;

public class CloseTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "CloseTest";

    public CloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(CloseTest.class);
    }

    public boolean share() {
        return false;
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testCloseSession() throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        MessagePopulatorVerifier verifier = PopulatorVerifierFactory.create(message);
        verifier.populate(message);
        Message received = this.sendReceive(message, DESTINATION);
        session.close();
        message.clearBody();
        verifier.populate(message);
        verifier.verify(received);
        try {
            received.acknowledge();
            CloseTest.fail((String)"Expected IllegalStateException to be thrown when invoking ackwnowledge for a closed session");
        }
        catch (IllegalStateException expected) {
        }
        catch (Exception exception) {
            CloseTest.fail((String)("Expected IllegalStateException to be thrown when invoking ackwnowledge for a closed session, but got: " + exception));
        }
    }

    public void testCloseConnection() throws Exception {
        TestContext context = this.getContext();
        Connection connection = context.getConnection();
        Message message = context.getMessage();
        MessagePopulatorVerifier verifier = PopulatorVerifierFactory.create(message);
        verifier.populate(message);
        Message received = this.sendReceive(message, DESTINATION);
        connection.close();
        message.clearBody();
        verifier.populate(message);
        verifier.verify(received);
        try {
            received.acknowledge();
            CloseTest.fail((String)"Expected IllegalStateException to be thrown when invoking ackwnowledge for a closed connection");
        }
        catch (IllegalStateException expected) {
        }
        catch (Exception exception) {
            CloseTest.fail((String)("Expected IllegalStateException to be thrown when invoking ackwnowledge for a closed connection, but got: " + exception));
        }
    }
}

