/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.copy;

import java.util.Arrays;
import javax.jms.BytesMessage;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class BytesMessageTest
extends AbstractMessageTestCase {
    public BytesMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(BytesMessageTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testWriteBytesCopy() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        byte[] buffer = new byte[10];
        message.writeBytes(bytes);
        message.reset();
        Arrays.fill(bytes, (byte)1);
        message.readBytes(buffer);
        BytesMessageTest.assertTrue((String)"BytesMessage.writeBytes(byte[]) did not copy the array", (!Arrays.equals(bytes, buffer) ? 1 : 0) != 0);
    }

    public void testPartialWriteBytesCopy() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        BytesMessage message = (BytesMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        byte[] buffer = new byte[10];
        message.writeBytes(bytes, 1, 9);
        message.reset();
        Arrays.fill(bytes, (byte)1);
        message.readBytes(buffer);
        BytesMessageTest.assertTrue((String)"BytesMessage.writeBytes(byte[], int, int) did not copy the array", (!Arrays.equals(bytes, buffer) ? 1 : 0) != 0);
    }
}

