/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.copy;

import java.io.Serializable;
import java.util.Arrays;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.MessageValues;

public class ObjectMessageTest
extends AbstractMessageTestCase
implements MessageValues {
    public ObjectMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(ObjectMessageTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testByteArrayCopy() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        ObjectMessage message = (ObjectMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        message.setObject((Serializable)bytes);
        Arrays.fill(bytes, (byte)1);
        byte[] value = (byte[])message.getObject();
        ObjectMessageTest.assertTrue((String)"ObjectMessage.setObject() did not copy the byte array", (!Arrays.equals(value, bytes) ? 1 : 0) != 0);
        byte[] value1 = (byte[])message.getObject();
        byte[] value2 = (byte[])message.getObject();
        ObjectMessageTest.assertTrue((String)"ObjectMessage.getObject() did not copy the byte array", (value1 != value2 ? 1 : 0) != 0);
    }

    public void testCustomObjectCopy() throws Exception {
        TestContext context = this.getContext();
        ObjectMessage message = (ObjectMessage)context.getMessage();
        MyObject source = new MyObject();
        source.setContent("ABC");
        message.setObject((Serializable)source);
        MyObject copy = (MyObject)message.getObject();
        ObjectMessageTest.assertTrue((String)"ObjectMessage.setObject() did not copy the object", (source != copy ? 1 : 0) != 0);
        ObjectMessageTest.assertTrue((String)"ObjectMessage.setObject() did not perform a deep copy of the object", (source.getContent() != copy.getContent() ? 1 : 0) != 0);
        source.setContent("DEF");
        copy = (MyObject)message.getObject();
        ObjectMessageTest.assertTrue((String)"ObjectMessage.setObject() did not copy the object", (!source.getContent().equals(copy.getContent()) ? 1 : 0) != 0);
    }

    public void testCopyAtConstruction() throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        MyObject source = new MyObject();
        source.setContent("ABC");
        ObjectMessage message = session.createObjectMessage((Serializable)source);
        MyObject copy = (MyObject)message.getObject();
        ObjectMessageTest.assertTrue((String)"ObjectMessage.setObject() did not copy the object", (source != copy ? 1 : 0) != 0);
        ObjectMessageTest.assertTrue((String)"ObjectMessage.setObject() did not perform a deep copy of the object", (source.getContent() != copy.getContent() ? 1 : 0) != 0);
    }

    public static class MyObject
    implements Serializable {
        private String _content = null;

        public void setContent(String content) {
            this._content = content;
        }

        public String getContent() {
            return this._content;
        }
    }
}

