/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.copy;

import java.util.Arrays;
import javax.jms.StreamMessage;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.MessageValues;

public class StreamMessageTest
extends AbstractMessageTestCase
implements MessageValues {
    public StreamMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(StreamMessageTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testWriteBytesCopy() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        message.writeBytes(bytes);
        message.reset();
        Arrays.fill(bytes, (byte)1);
        byte[] buffer = new byte[10];
        message.readBytes(buffer);
        StreamMessageTest.assertTrue((String)"StreamMessage.writeBytes(byte[]) did not copy the array", (!Arrays.equals(buffer, bytes) ? 1 : 0) != 0);
    }

    public void testPartialWriteBytesCopy() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        message.writeBytes(bytes, 1, 9);
        message.reset();
        Arrays.fill(bytes, (byte)1);
        byte[] buffer = new byte[10];
        message.readBytes(buffer);
        StreamMessageTest.assertTrue((String)"StreamMessage.writeBytes(byte[], int, int) did not copy the array", (!Arrays.equals(buffer, bytes) ? 1 : 0) != 0);
    }

    public void testByteArrayCopy() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        message.writeObject((Object)bytes);
        message.reset();
        Arrays.fill(bytes, (byte)1);
        byte[] buffer = (byte[])message.readObject();
        StreamMessageTest.assertTrue((String)"StreamMessage.writeObject() did not copy the array", (!Arrays.equals(buffer, bytes) ? 1 : 0) != 0);
    }
}

