/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.header;

import javax.jms.Destination;
import javax.jms.Message;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class JMSDestinationTest
extends AbstractSendReceiveTestCase {
    private static final String DEST1 = "JMSDestinationTest1";
    private static final String DEST2 = "JMSDestinationTest2";
    private static final String[] DESTINATIONS = new String[]{"JMSDestinationTest1", "JMSDestinationTest2"};

    public JMSDestinationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(JMSDestinationTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    public void testJMSDestination() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        Destination dest = this.getDestination(DEST1);
        JMSDestinationTest.assertNull((String)"JMSDestination should initially be null", (Object)message.getJMSDestination());
        Message received = this.sendReceive(message, dest);
        Destination sentDest = message.getJMSDestination();
        JMSDestinationTest.assertTrue((String)"JMSDestination after send not equal to that specified", (boolean)DestinationHelper.equal(dest, sentDest));
        Destination receivedDest = received.getJMSDestination();
        JMSDestinationTest.assertTrue((String)"JMSDestination on receipt not equal to that when sent", (boolean)DestinationHelper.equal(dest, receivedDest));
    }

    public void testJMSDestinationOnResend() throws Exception {
        Message received1;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        Destination dest1 = this.getDestination(DEST1);
        Destination dest2 = this.getDestination(DEST1);
        Message resent = received1 = this.sendReceive(message, dest1);
        Message received2 = this.sendReceive(resent, dest2);
        JMSDestinationTest.assertTrue((String)"JMSDestination on resend not equal to that specified", (boolean)DestinationHelper.equal(dest2, resent.getJMSDestination()));
        JMSDestinationTest.assertTrue((String)"JMSDestination on receipt not equal to that when resent", (boolean)DestinationHelper.equal(dest2, received2.getJMSDestination()));
    }
}

