/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.header;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class JMSMessageIDTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "JMSMessageIDTest";

    public JMSMessageIDTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(JMSMessageIDTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testJMSMessageID() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        Message received1 = this.sendReceive(message, DESTINATION);
        String sentID1 = message.getJMSMessageID();
        String receivedID1 = received1.getJMSMessageID();
        JMSMessageIDTest.assertNotNull((String)"JMSMessageID after send should not be null", (Object)sentID1);
        JMSMessageIDTest.assertNotNull((String)"JMSMessageID on received message should not be null", (Object)receivedID1);
        JMSMessageIDTest.assertEquals((String)"JMSMessageID on received message not equal to that sent:", (String)sentID1, (String)receivedID1);
        Message resent = received1;
        Message received2 = this.sendReceive(resent, DESTINATION);
        String sentID2 = resent.getJMSMessageID();
        String receivedID2 = received2.getJMSMessageID();
        JMSMessageIDTest.assertNotNull((String)"JMSMessageID after resend should not be null", (Object)sentID2);
        JMSMessageIDTest.assertNotNull((String)"JMSMessageID on received message should not be null", (Object)receivedID2);
        if (sentID1.equals(sentID2)) {
            JMSMessageIDTest.fail((String)"A new JMSMessageID wasn't allocated for the resent message");
        }
        JMSMessageIDTest.assertEquals((String)"JMSMessageID on received message not equal to that sent:", (String)sentID2, (String)receivedID2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJMSMessageIDAssignment() throws Exception {
        int count = 3;
        ArrayList<String> messageIds = new ArrayList<String>();
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        MessageSender sender = null;
        MessageReceiver receiver = null;
        long timeout = context.getMessagingBehaviour().getTimeout();
        try {
            sender = this.createSender(DESTINATION);
            receiver = this.createReceiver(DESTINATION);
            for (int i = 0; i < 3; ++i) {
                sender.send(message, 1);
                String messageId = message.getJMSMessageID();
                JMSMessageIDTest.assertNotNull((Object)messageId);
                if (messageIds.contains(messageId)) {
                    JMSMessageIDTest.fail((String)"Allocated JMSMessageID is not unique");
                }
                messageIds.add(messageId);
            }
            if (session.getTransacted()) {
                session.commit();
            }
            List messages = this.receive(receiver, 3);
            Iterator iterator = messages.iterator();
            ArrayList<String> receivedIds = new ArrayList<String>();
            while (iterator.hasNext()) {
                Message received = (Message)iterator.next();
                receivedIds.add(received.getJMSMessageID());
            }
            if (session.getTransacted()) {
                session.commit();
            }
            JMSMessageIDTest.assertEquals((String)"JMSMessageIDs of received messages don't match those sent: ", messageIds, receivedIds);
        }
        finally {
            this.close(sender);
            this.close(receiver);
        }
    }

    public void testJMSMessageIDPrefix() throws Exception {
        String prefix = "ID:";
        TestContext context = this.getContext();
        Message message = context.getMessage();
        this.send(message, DESTINATION);
        String messageID = message.getJMSMessageID();
        if (!messageID.startsWith("ID:")) {
            JMSMessageIDTest.fail((String)"JMSMessageID must start with prefix=ID:");
        }
    }
}

