/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.header;

import javax.jms.Destination;
import javax.jms.Message;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class JMSReplyToTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "JMSReplyToTest";
    private static final String REPLY_TO = "ReplyTo";

    public JMSReplyToTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(JMSReplyToTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION, REPLY_TO};
    }

    public void testReplyTo() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        JMSReplyToTest.assertNull((String)"JMSReplyTo should initially be null", (Object)message.getJMSReplyTo());
        Destination replyTo = this.getDestination(REPLY_TO);
        message.setJMSReplyTo(replyTo);
        Message received1 = this.sendReceive(message, DESTINATION);
        JMSReplyToTest.assertTrue((boolean)DestinationHelper.equal(replyTo, message.getJMSReplyTo()));
        JMSReplyToTest.assertTrue((boolean)DestinationHelper.equal(replyTo, received1.getJMSReplyTo()));
        Message received2 = this.sendReceive(message, received1.getJMSReplyTo());
        JMSReplyToTest.assertTrue((boolean)DestinationHelper.equal(replyTo, received2.getJMSReplyTo()));
    }
}

