/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.map;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.ClassHelper;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.Conversions;
import org.exolab.jmscts.test.message.util.MessageValues;

public class MapMessageTest
extends AbstractMessageTestCase
implements MessageValues {
    private static final Object[][] CONVERSION_VALUES = new Object[][]{BOOLEANS, BYTES, SHORTS, CHARS, INTS, LONGS, FLOATS, DOUBLES, (Object[])BYTE_ARRAYS};
    private static final Float[] FLOAT_CONVERSION_VALUES = new Float[]{new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE)};
    private static final Double[] DOUBLE_CONVERSION_VALUES = new Double[]{new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE)};
    private static final Object[][] STRING_CONVERSION_VALUES = new Object[][]{BOOLEANS, BYTES, SHORTS, INTS, LONGS, FLOAT_CONVERSION_VALUES, DOUBLE_CONVERSION_VALUES, STRINGS};

    public MapMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(MapMessageTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testConversion() throws Exception {
        String prefix = "testConversion";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        int id = 0;
        for (int i = 0; i < CONVERSION_VALUES.length; ++i) {
            int j = 0;
            while (j < CONVERSION_VALUES[i].length) {
                Object value = CONVERSION_VALUES[i][j];
                this.set(message, value, "testConversion" + id);
                Class<?> type = value.getClass();
                Class[] valid = Conversions.getValidConversions(type);
                for (int k = 0; k < valid.length; ++k) {
                    Object result = this.get(message, valid[k], "testConversion" + id);
                    Object converted = Conversions.convert(value, valid[k]);
                    if (converted instanceof byte[]) {
                        if (Arrays.equals((byte[])result, (byte[])converted)) continue;
                        MapMessageTest.fail((String)"Result byte array different to that set");
                        continue;
                    }
                    if (converted.equals(result)) continue;
                    MapMessageTest.fail((String)("Conversion of type=" + ClassHelper.getPrimitiveName(type) + " to type=" + ClassHelper.getPrimitiveName(valid[k]) + " failed. Expected value=" + converted + ", but got value=" + result));
                }
                ++j;
                ++id;
            }
        }
    }

    public void testStringConversion() throws Exception {
        String prefix = "testStringConversion";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        int id = 0;
        for (int i = 0; i < STRING_CONVERSION_VALUES.length; ++i) {
            for (int j = 0; j < STRING_CONVERSION_VALUES[i].length; ++j) {
                Object value = STRING_CONVERSION_VALUES[i][j];
                this.set(message, value.toString(), "testStringConversion" + id);
                Class<?> type = value.getClass();
                Object result = this.get(message, type, "testStringConversion" + id);
                if (!value.equals(result)) {
                    MapMessageTest.fail((String)("Conversion of type=String to type=" + ClassHelper.getPrimitiveName(type) + " failed. Expected value=" + value + ", but got value=" + result));
                }
                ++id;
            }
        }
    }

    public void testInvalidConversion() throws Exception {
        String prefix = "testInvalidConversion";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        int id = 0;
        for (int i = 0; i < ALL_VALUES.length; ++i) {
            for (int j = 0; j < ALL_VALUES[i].length; ++j) {
                Object value = ALL_VALUES[i][j];
                this.set(message, value, "testInvalidConversion" + id);
                Class<?> type = value.getClass();
                Class[] invalid = Conversions.getInvalidConversions(type);
                for (int k = 0; k < invalid.length; ++k) {
                    try {
                        this.get(message, invalid[k], "testInvalidConversion" + id);
                        MapMessageTest.fail((String)("Expected MessageFormatException to be thrown when getting type=" + ClassHelper.getPrimitiveName(invalid[k]) + " for type=" + ClassHelper.getPrimitiveName(type)));
                        continue;
                    }
                    catch (MessageFormatException expected) {
                        continue;
                    }
                    catch (Exception exception) {
                        MapMessageTest.fail((String)("Expected MessageFormatException to be thrown when getting type=" + ClassHelper.getPrimitiveName(invalid[k]) + " for type=" + ClassHelper.getPrimitiveName(type) + ", but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
                    }
                }
                Object result = this.get(message, type, "testInvalidConversion" + id);
                this.compare(value, result);
                ++id;
            }
        }
    }

    public void testInvalidNumericConversion() throws Exception {
        String prefix = "testInvalidNumericConversion";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        Class[] numerics = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        String[] invalidNos = new String[]{"a", "0x00", "NaN", "-Infinity", "+Infinity"};
        int id = 0;
        for (int i = 0; i < invalidNos.length; ++i) {
            String value = invalidNos[i];
            this.set(message, value, "testInvalidNumericConversion" + id);
            for (int j = 0; j < numerics.length; ++j) {
                try {
                    this.get(message, numerics[j], "testInvalidNumericConversion" + id);
                    MapMessageTest.fail((String)("Expected NumberFormatException to be thrown when getting value=" + value + " as type=" + ClassHelper.getPrimitiveName(numerics[j])));
                    continue;
                }
                catch (NumberFormatException expected) {
                    continue;
                }
                catch (Exception exception) {
                    MapMessageTest.fail((String)("Expected NumberFormatException to be thrown when getting value=" + value + " as type=" + ClassHelper.getPrimitiveName(numerics[j]) + ", but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
                }
            }
            ++id;
        }
    }

    public void testNullConversion() throws Exception {
        String key = "testNullConversion";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        try {
            this.set(message, null, "testNullConversion");
        }
        catch (Exception exception) {
            MapMessageTest.fail((String)("Failed to set a null object value to MapMessage, exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        Object result = this.getNull(message, Boolean.class, "testNullConversion", null);
        if (!result.equals(Boolean.FALSE)) {
            MapMessageTest.fail((String)"Expected MapMessage.getBoolean() to return false for a null value");
        }
        if ((result = this.getNull(message, String.class, "testNullConversion", null)) != null) {
            MapMessageTest.fail((String)"Expected MapMessage.getString() to return null for a null value");
        }
        if ((result = this.getNull(message, [B.class, "testNullConversion", null)) != null) {
            MapMessageTest.fail((String)"Expected MapMessage.getBytes() to return null for a null value");
        }
        this.getNull(message, Byte.class, "testNullConversion", NumberFormatException.class);
        this.getNull(message, Short.class, "testNullConversion", NumberFormatException.class);
        this.getNull(message, Character.class, "testNullConversion", NullPointerException.class);
        this.getNull(message, Integer.class, "testNullConversion", NumberFormatException.class);
        this.getNull(message, Long.class, "testNullConversion", NumberFormatException.class);
        this.getNull(message, Float.class, "testNullConversion", NullPointerException.class);
        this.getNull(message, Double.class, "testNullConversion", NullPointerException.class);
    }

    public void testSetObject() throws Exception {
        int j;
        int i;
        String prefix = "testSetObject";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        int id = 0;
        for (i = 0; i < ALL_VALUES.length; ++i) {
            for (j = 0; j < ALL_VALUES[i].length; ++j) {
                message.setObject("testSetObject" + id, ALL_VALUES[i][j]);
                ++id;
            }
        }
        id = 0;
        for (i = 0; i < ALL_VALUES.length; ++i) {
            for (j = 0; j < ALL_VALUES[i].length; ++j) {
                Object value = message.getObject("testSetObject" + id);
                if (ALL_VALUES[i][j] instanceof byte[]) {
                    byte[] source = (byte[])ALL_VALUES[i][j];
                    byte[] result = (byte[])value;
                    MapMessageTest.assertTrue((boolean)Arrays.equals(source, result));
                } else {
                    MapMessageTest.assertTrue((boolean)ALL_VALUES[i][j].equals(value));
                }
                ++id;
            }
        }
    }

    public void testInvalidObject() throws Exception {
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        try {
            message.setObject("testInvalidObject", (Object)new BigDecimal(0.0));
            MapMessageTest.fail((String)"MapMessage.setObject() should only support objectified primitives");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testMap() throws Exception {
        String prefix = "testMap";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        HashMap elements = this.populate(message);
        Iterator iter = elements.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            String key = (String)element.getKey();
            Object value = element.getValue();
            Object result = this.get(message, value.getClass(), key);
            this.compare(value, result);
            result = message.getObject(key);
            this.compare(value, result);
        }
    }

    public void testGetMapNames() throws Exception {
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        this.checkEmpty(message);
        HashMap elements = this.populate(message);
        LinkedList names = new LinkedList();
        Enumeration enumeration = message.getMapNames();
        while (enumeration.hasMoreElements()) {
            names.add(enumeration.nextElement());
        }
        if (elements.size() != names.size()) {
            MapMessageTest.fail((String)("getMapNames() returned a different number of names to that expected. Expected count=" + elements.size() + " but got count=" + names.size()));
        }
        if (!names.containsAll(elements.keySet())) {
            MapMessageTest.fail((String)"getMapNames() returned a different set of names to that expected");
        }
        message.clearBody();
        this.checkEmpty(message);
    }

    public void testItemExists() throws Exception {
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        HashMap elements = this.populate(message);
        Iterator iter = elements.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (message.itemExists(name)) continue;
            MapMessageTest.fail((String)"itemExists() returned false for an existing element");
        }
        if (message.itemExists("bad_item_name")) {
            MapMessageTest.fail((String)"itemExists() returned true for a non-existent element");
        }
    }

    public void testUnset() throws Exception {
        String key = "testUnset";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        Object result = this.getNull(message, Boolean.class, "testUnset", null);
        MapMessageTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        result = this.getNull(message, String.class, "testUnset", null);
        MapMessageTest.assertEquals(null, (Object)result);
        result = this.getNull(message, [B.class, "testUnset", null);
        MapMessageTest.assertEquals(null, (Object)result);
        this.getNull(message, Byte.class, "testUnset", NumberFormatException.class);
        this.getNull(message, Short.class, "testUnset", NumberFormatException.class);
        this.getNull(message, Character.class, "testUnset", NullPointerException.class);
        this.getNull(message, Integer.class, "testUnset", NumberFormatException.class);
        this.getNull(message, Long.class, "testUnset", NumberFormatException.class);
        this.getNull(message, Float.class, "testUnset", NullPointerException.class);
        this.getNull(message, Double.class, "testUnset", NullPointerException.class);
    }

    public void testCase() throws Exception {
        String upperKey = "ABC";
        String lowerKey = "ABC".toLowerCase();
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        for (int i = 0; i < ALL_VALUES.length; ++i) {
            if (ALL_VALUES[i].length < 2) {
                throw new Exception("Each entry in ALL_VALUES must have at least 2 distinct values");
            }
            Object value1 = ALL_VALUES[i][0];
            Object value2 = ALL_VALUES[i][1];
            this.set(message, value1, "ABC");
            this.set(message, value2, lowerKey);
            this.compare(value1, this.get(message, value1.getClass(), "ABC"));
            this.compare(value2, this.get(message, value2.getClass(), lowerKey));
        }
        message.clearBody();
        String value1 = STRINGS[0];
        Integer value2 = INTS[0];
        message.setString("ABC", value1);
        message.setInt(lowerKey, value2.intValue());
        this.compare(value1, this.get(message, value1.getClass(), "ABC"));
        this.compare(value2, this.get(message, value2.getClass(), lowerKey));
    }

    private void checkEmpty(MapMessage message) throws Exception {
        Enumeration enumeration = message.getMapNames();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            ++count;
        }
        if (count != 0) {
            MapMessageTest.fail((String)("Expected getMapNames to return no elements for an empty MapMessage, but returned=" + count + " names"));
        }
    }

    private void compare(Object expected, Object result) {
        if (expected instanceof byte[]) {
            if (!Arrays.equals((byte[])expected, (byte[])result)) {
                MapMessageTest.fail((String)"Byte array returned by MapMessage does not match that expected");
            }
        } else if (!expected.equals(result)) {
            MapMessageTest.fail((String)("Value returned by MapMessage does not match that expected. Expected value=" + expected + ", but got value=" + result));
        }
    }

    private HashMap populate(MapMessage message) throws Exception {
        String name;
        int j;
        int i;
        String prefix = "element";
        HashMap<String, Object> result = new HashMap<String, Object>();
        int id = 0;
        for (i = 0; i < ALL_VALUES.length; ++i) {
            for (j = 0; j < ALL_VALUES[i].length; ++j) {
                name = "element" + id;
                this.set(message, ALL_VALUES[i][j], name);
                result.put(name, ALL_VALUES[i][j]);
                ++id;
            }
        }
        for (i = 0; i < ALL_VALUES.length; ++i) {
            for (j = 0; j < ALL_VALUES[i].length; ++j) {
                name = "element" + id;
                message.setObject(name, ALL_VALUES[i][j]);
                result.put(name, ALL_VALUES[i][j]);
                ++id;
            }
        }
        for (i = 0; i < BYTE_ARRAYS.length; ++i) {
            String name2 = "element" + id;
            message.setBytes(name2, BYTE_ARRAYS[i], 0, BYTE_ARRAYS[i].length);
            result.put(name2, BYTE_ARRAYS[i]);
            ++id;
        }
        return result;
    }

    private void set(MapMessage message, Object value, String key) throws Exception {
        if (value instanceof Boolean) {
            message.setBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            message.setByte(key, ((Byte)value).byteValue());
        } else if (value instanceof Short) {
            message.setShort(key, ((Short)value).shortValue());
        } else if (value instanceof Character) {
            message.setChar(key, ((Character)value).charValue());
        } else if (value instanceof Integer) {
            message.setInt(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            message.setLong(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            message.setFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            message.setDouble(key, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            message.setString(key, (String)value);
        } else if (value instanceof byte[]) {
            message.setBytes(key, (byte[])value);
        } else {
            message.setObject(key, value);
        }
    }

    private Object get(MapMessage message, Class type, String key) throws Exception {
        Object result = null;
        if (type.equals(Boolean.class)) {
            result = new Boolean(message.getBoolean(key));
        } else if (type.equals(Byte.class)) {
            result = new Byte(message.getByte(key));
        } else if (type.equals(Short.class)) {
            result = new Short(message.getShort(key));
        } else if (type.equals(Character.class)) {
            result = new Character(message.getChar(key));
        } else if (type.equals(Integer.class)) {
            result = new Integer(message.getInt(key));
        } else if (type.equals(Long.class)) {
            result = new Long(message.getLong(key));
        } else if (type.equals(Float.class)) {
            result = new Float(message.getFloat(key));
        } else if (type.equals(Double.class)) {
            result = new Double(message.getDouble(key));
        } else if (type.equals(String.class)) {
            result = message.getString(key);
        } else if (type.equals([B.class)) {
            result = message.getBytes(key);
        }
        return result;
    }

    private Object getNull(MapMessage message, Class type, String key, Class exceptionType) throws Exception {
        Object result;
        block4: {
            result = null;
            try {
                result = this.get(message, type, key);
                if (exceptionType != null) {
                    MapMessageTest.fail((String)("Expected exception, type=" + exceptionType.getName() + " to be thrown when getting null as type=" + ClassHelper.getPrimitiveName(type)));
                }
            }
            catch (Exception exception) {
                if (exceptionType == null) {
                    MapMessageTest.fail((String)("Did not expect exception to be thrown when getting null as type=" + ClassHelper.getPrimitiveName(type) + " but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
                }
                if (exceptionType.isAssignableFrom(exception.getClass())) break block4;
                MapMessageTest.fail((String)("Expected exception, type=" + exceptionType.getName() + " to be thrown when getting null as type=" + ClassHelper.getPrimitiveName(type) + ", but got " + "exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
        }
        return result;
    }
}

